/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.security.app.signature.ISignatureContainerEntryProcessor;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.validation.IValidationDataCollector;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.method.common.signature.AdESSignerTools;
import de.intarsys.security.method.pdf.signature.CMSBasedPDDocumentSignerFactory;
import de.intarsys.security.method.pdf.signature.CMSSignatureContainerBuilderFactoryPAdESEnhanced;
import de.intarsys.security.method.pdf.signature.DSECAdESDetached;
import de.intarsys.security.method.pdf.signature.IPDDocumentSignatureEncoder;
import de.intarsys.security.method.pdf.signature.PDDocumentSigner;
import de.intarsys.security.method.pdf.validation.PDFValidationDataExtender;
import de.intarsys.security.signature.ValidationDataOptions;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

@SingletonClass
public class DSFactoryPAdESEnhanced
extends CMSBasedPDDocumentSignerFactory {
    private static final DSFactoryPAdESEnhanced INSTANCE = new DSFactoryPAdESEnhanced();

    public static DSFactoryPAdESEnhanced get() {
        return INSTANCE;
    }

    @Override
    protected PDDocumentSigner basicCreateInstance(IArgs args) throws ObjectCreationException {
        PDDocumentSigner signer = super.basicCreateInstance(args);
        ISigner digestSigner = AdESSignerTools.getSigner((IArgs)args);
        ValidationDataOptions options = AdESSignerTools.getValidationDataOptions((IArgs)args);
        if (options.isAddValidationData()) {
            PDFValidationDataExtender extender = new PDFValidationDataExtender();
            extender.setValidationDataOptions(options);
            extender.setValidationDataCollector(() -> (IValidationDataCollector)AdapterTools.getAdapter((Object)digestSigner, IValidationDataCollector.class, null));
            signer.addFinalizer((ISignatureContainerEntryProcessor)extender);
        }
        return signer;
    }

    @Override
    protected IPDDocumentSignatureEncoder createEncoder(IFactory<ICMSSignatureContainerBuilder> factory, IArgs cmsSignerArgs) throws ObjectCreationException {
        return new DSECAdESDetached(factory, cmsSignerArgs);
    }

    @Override
    protected IFactory<ICMSSignatureContainerBuilder> getCMSBuilderFactory() {
        return CMSSignatureContainerBuilderFactoryPAdESEnhanced.get();
    }

    public String getLabel() {
        return "PAdES baseline";
    }

    @Override
    protected void prepareDigestSigner(ISigner signer, IArgs args) throws ObjectCreationException {
        super.prepareDigestSigner(signer, args);
        signer.setSignatureFormat(SignatureFormat.PAdES);
    }
}

