/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectProxy;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDBuildProperties;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.method.pdf.signature.IStoreSignatureField;
import de.intarsys.security.method.pdf.signature.PDSignatureByteRange;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.tools.date.TimeEnvironment;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.time.Instant;

public abstract class AbstractStoreSignatureField
implements IStoreSignatureField {
    public static final COSName CN_ADOBE_PPKLITE = COSName.constant((String)"Adobe.PPKLite");
    public static final COSName CN_ADOBE_PPKMS = COSName.constant((String)"Adobe.PPKMS");
    public static final COSName CN_ASIGN_ECDSA = COSName.constant((String)"asign.ECDSA");
    private final COSName filterName;
    private final COSName subFilterName;
    private PDSignature pdSignature;
    private COSContentProxy contentProxy;
    private COSByteRangeProxy byteRangeProxy;

    protected AbstractStoreSignatureField(COSName filterName, COSName subFilterName) {
        this.filterName = filterName;
        this.subFilterName = subFilterName;
    }

    protected byte[] createContents(IRandomAccess randomAccess) throws IOException {
        ISignatureData signatureData = this.signByteRange(randomAccess);
        byte[] content = signatureData.getEncodedSignature();
        return this.encodeContent(content);
    }

    protected abstract byte[] encodeContent(byte[] var1) throws IOException;

    protected COSArray getByteRange() {
        return (COSArray)this.byteRangeProxy.getObject();
    }

    protected COSByteRangeProxy getByteRangeProxy() {
        return this.byteRangeProxy;
    }

    public long getContentPosition() {
        return this.contentProxy.getPosition();
    }

    protected COSContentProxy getContentProxy() {
        return this.contentProxy;
    }

    protected abstract int getContentSize();

    protected abstract IDevice getDevice();

    public PDSignature getPdSignature() {
        return this.pdSignature;
    }

    protected long getSignatureTimeOffset() {
        IDevice device = this.getDevice();
        if (device != null) {
            try {
                Long pdfSignatureTimeOffset = (Long)device.getValue("pdfSignatureTimeOffset");
                if (pdfSignatureTimeOffset != null) {
                    return pdfSignatureTimeOffset;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    @Override
    public void initialize(PDSignature pPDSignature) {
        this.pdSignature = pPDSignature;
        this.contentProxy = new COSContentProxy();
        this.byteRangeProxy = new COSByteRangeProxy();
        this.getPdSignature().cosSetField(PDSignature.DK_Contents, (COSObject)this.contentProxy);
        this.getPdSignature().cosSetField(PDSignature.DK_ByteRange, (COSObject)this.byteRangeProxy);
        this.getPdSignature().setFilter(this.filterName);
        this.getPdSignature().setSubFilter(this.subFilterName);
        long offset = this.getSignatureTimeOffset();
        Instant now = TimeEnvironment.get().now();
        this.getPdSignature().setDate(CDSDate.createFrom((Instant)now.plusMillis(offset)));
        PDBuildProperties buildProp = this.getPdSignature().getBuildProperties();
        if (buildProp != null && buildProp.getFilter() != null) {
            buildProp.getFilter().setName(this.filterName.stringValue());
        }
    }

    protected ISignatureData signByteRange(IRandomAccess randomAccess) throws IOException {
        randomAccess.seek(0L);
        PDSignatureByteRange byteRange = new PDSignatureByteRange(this.getByteRange(), randomAccess);
        try {
            return this.signByteRange(byteRange);
        }
        catch (SecurityApplicationException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected abstract ISignatureData signByteRange(PDSignatureByteRange var1) throws SecurityApplicationException, IOException;

    class COSByteRangeProxy
    extends COSObjectProxy {
        public COSByteRangeProxy() {
            this.reserveData(64);
        }

        protected COSObject createCOSObject(IRandomAccess randomAccess) throws IOException {
            COSArray range = COSArray.create();
            long start = 0L;
            long length = (int)AbstractStoreSignatureField.this.getContentProxy().getPosition();
            range.add((COSObject)COSInteger.create((long)start));
            range.add((COSObject)COSInteger.create((long)length));
            start = length + (long)AbstractStoreSignatureField.this.getContentProxy().getLength();
            length = randomAccess.getLength() - start;
            range.add((COSObject)COSInteger.create((long)start));
            range.add((COSObject)COSInteger.create((long)length));
            return range;
        }

        public void ended(COSWriter writer) {
        }

        public void writeByteRange(COSWriter writer) throws IOException {
            super.ended(writer);
        }
    }

    class COSContentProxy
    extends COSObjectProxy {
        public COSContentProxy() {
            this.reserveData(AbstractStoreSignatureField.this.getContentSize() * 2 + 2);
        }

        protected COSObject createCOSObject(IRandomAccess randomAccess) throws IOException {
            byte[] content = AbstractStoreSignatureField.this.createContents(randomAccess);
            return COSString.createHex((byte[])content);
        }

        public void ended(COSWriter writer) throws IOException {
            AbstractStoreSignatureField.this.getByteRangeProxy().writeByteRange(writer);
            super.ended(writer);
        }

        public void setObject(COSObject object) {
            super.setObject(object);
        }
    }
}

