/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.security;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyStoreTools {
    private static final Logger Log = LoggerFactory.getLogger(KeyStoreTools.class);

    public static String createAlias(KeyStore ks) throws KeyStoreException {
        long aliasInt;
        String alias = null;
        while (ks.containsAlias(alias = String.valueOf(aliasInt = (long)((double)System.currentTimeMillis() * Math.random())))) {
        }
        return alias;
    }

    public static KeyStore createJavaKeyStore(ILocator locator, char[] password) throws IOException, GeneralSecurityException {
        return KeyStoreTools.createJavaKeyStore(locator, KeyStore.getDefaultType(), password);
    }

    public static KeyStore createJavaKeyStore(ILocator locator, String passwd) throws IOException, GeneralSecurityException {
        return KeyStoreTools.createJavaKeyStore(locator, "JKS", passwd);
    }

    public static KeyStore createJavaKeyStore(ILocator locator, String type, char[] password) throws IOException, GeneralSecurityException {
        if (locator == null) {
            return null;
        }
        Log.trace("key store " + locator.getPath() + " loading");
        if (locator.exists()) {
            KeyStore keyStore;
            block10: {
                InputStream is = locator.getInputStream();
                try {
                    KeyStore keyStore2 = KeyStore.getInstance(type);
                    keyStore2.load(is, password);
                    Log.trace("key store " + locator.getPath() + " loaded");
                    keyStore = keyStore2;
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | GeneralSecurityException e) {
                        Log.trace("key store " + locator.getPath() + " load failed");
                        throw e;
                    }
                }
                is.close();
            }
            return keyStore;
        }
        Log.trace("key store " + locator.getPath() + " not found");
        throw new FileNotFoundException(locator.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore createJavaKeyStore(ILocator locator, String type, String passwd) throws IOException, GeneralSecurityException {
        KeyStore keystore = null;
        InputStream input = null;
        try {
            input = locator.getInputStream();
            keystore = KeyStore.getInstance(type);
            keystore.load(input, passwd == null ? null : passwd.toCharArray());
        }
        finally {
            StreamTools.close((Closeable)input);
        }
        return keystore;
    }

    private KeyStoreTools() {
    }
}

