/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget;

import de.intarsys.pdf.app.appearance.ITextFormatProvider;
import de.intarsys.pdf.app.appearance.widget.LayoutTools;
import de.intarsys.pdf.app.endorsement.Endorsement;
import de.intarsys.pdf.app.endorsement.EndorsementEvidence;
import de.intarsys.pdf.design.shape.Shape;
import de.intarsys.pdf.design.shape.sample.Samples;
import de.intarsys.pdf.design.widget.AnnotationDefinition;
import de.intarsys.pdf.design.widget.AnnotationType;
import de.intarsys.pdf.design.widget.IFieldDefinition;
import de.intarsys.pdf.design.widget.IFieldDefinitionStrategy;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.enumeration.common.RectAlignment;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.geometry.PointSpec;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;
import java.util.Collections;
import java.util.List;

public abstract class CommonFieldDefinitionStrategy
implements IFieldDefinitionStrategy {
    private String lastFieldName;

    protected AnnotationDefinition createAnnotationDefinition(IFieldDefinition fieldDefinition, IArgs args) {
        return new AnnotationDefinition(fieldDefinition, args);
    }

    protected IArgs createAnnotationDefinitionsFromEndorsement(IFieldDefinition fieldDefinition, EndorsementEvidence evidence) {
        Args annotationArgs = Args.create();
        annotationArgs.put("adjustForRotate", (Object)true);
        annotationArgs.put("x", (Object)Float.valueOf(evidence.getX()));
        annotationArgs.put("y", (Object)Float.valueOf(evidence.getY()));
        annotationArgs.put("width", (Object)Float.valueOf(evidence.getWidth()));
        annotationArgs.put("height", (Object)Float.valueOf(evidence.getHeight()));
        annotationArgs.put("hAlign", (Object)evidence.getHAlign());
        annotationArgs.put("vAlign", (Object)evidence.getVAlign());
        annotationArgs.put("pageRange", (Object)String.valueOf(evidence.getPage()));
        annotationArgs.put("created", (Object)evidence.getTimestamp());
        annotationArgs.put("title", LangTools.firstNonNull((Object[])new Object[]{evidence.getTitle(), fieldDefinition.getDefaultAnnotationDefinition().getTitle(), evidence.getDefaultTitle()}));
        annotationArgs.put("subject", LangTools.firstNonNull((Object[])new Object[]{evidence.getLabel(), fieldDefinition.getDefaultAnnotationDefinition().getSubject(), evidence.getDefaultLabel()}));
        annotationArgs.put("contents", LangTools.firstNonNull((Object[])new Object[]{evidence.getDescription(), fieldDefinition.getDefaultAnnotationDefinition().getContents(), evidence.getDefaultDescription()}));
        annotationArgs.put("annotationType", (Object)"markup");
        Shape shape = this.createShape(evidence);
        if (shape != null) {
            annotationArgs.put("shapes", (Object)ListTools.with((Object[])new Shape[]{shape}));
        } else {
            annotationArgs.put("shapes", Collections.emptyList());
        }
        return annotationArgs;
    }

    protected void createAnnotationDefinitionsFromEndorsement(IFieldDefinition fieldDefinition, List<AnnotationDefinition> annotationDefinitions) {
        IArgs argEndorsement = ArgTools.getArgs((IArgs)fieldDefinition.getContextArgs(), (String)"endorsement", null);
        Endorsement endorsement = Endorsement.createFromArgs((IArgs)argEndorsement);
        if (endorsement == null) {
            return;
        }
        for (EndorsementEvidence evidence : endorsement.getEvidences()) {
            IArgs annotationArgs = this.createAnnotationDefinitionsFromEndorsement(fieldDefinition, evidence);
            AnnotationDefinition annotDef = this.createAnnotationDefinition(fieldDefinition, annotationArgs);
            annotationDefinitions.add(annotDef);
        }
    }

    protected PDAcroFormField createField(PDDocument doc, IFieldDefinition fieldDefinition, List<AnnotationDefinition> annotationDefinitions) {
        AnnotationType defaultType = fieldDefinition.getDefaultAnnotationType(annotationDefinitions.size());
        boolean widgetExists = false;
        for (AnnotationDefinition annotDef : annotationDefinitions) {
            widgetExists = widgetExists || annotDef.getAnnotationType() == AnnotationType.widget || annotDef.getAnnotationType() == AnnotationType.auto && defaultType == AnnotationType.widget;
        }
        try {
            PDAcroFormField result = null;
            if (!widgetExists) {
                result = this.createFieldInvisible(fieldDefinition, result);
            }
            result = this.createFieldAnnotations(annotationDefinitions, AnnotationType.widget, defaultType, result);
            return (result = this.createFieldAnnotations(annotationDefinitions, AnnotationType.markup, defaultType, result)) == null ? null : result.getLogicalRoot();
        }
        catch (Exception e) {
            throw (IllegalArgumentException)ExceptionTools.unwrapTypedFromChain((Throwable)e, IllegalArgumentException.class);
        }
    }

    protected PDAcroFormField createFieldAnnotation(AnnotationDefinition annotDef) throws ObjectCreationException {
        PDAnnotation annot = annotDef.createAnnotations(this.getLastFieldName());
        if (annot instanceof PDWidgetAnnotation) {
            PDAcroFormField field = ((PDWidgetAnnotation)annot).getAcroFormField();
            if (StringTools.isEmpty((String)this.getLastFieldName())) {
                this.setLastFieldName(field.getLocalName());
            }
            return field;
        }
        return null;
    }

    protected PDAcroFormField createFieldAnnotations(List<AnnotationDefinition> annotationDefinitions, AnnotationType currentType, AnnotationType defaultType, PDAcroFormField currentField) throws ObjectCreationException {
        for (AnnotationDefinition annotDef : annotationDefinitions) {
            if (annotDef.getAnnotationType() == AnnotationType.auto) {
                annotDef.setAnnotationType(defaultType);
            }
            if (annotDef.getAnnotationType() != currentType) continue;
            if (currentField != null) {
                annotDef.setTextFormatProvider((ITextFormatProvider)LayoutTools.createTextFormat((PDAcroFormField)currentField));
            }
            PDAcroFormField tmpField = this.createFieldAnnotation(annotDef);
            currentField = currentField == null ? tmpField : currentField;
        }
        return currentField;
    }

    protected PDAcroFormField createFieldInvisible(IFieldDefinition fieldDefinition, PDAcroFormField result) throws ObjectCreationException {
        Args argsInvisible = Args.create();
        ArgTools.putPath((IArgs)argsInvisible, (String)"position", (Object)"0x0");
        ArgTools.putPath((IArgs)argsInvisible, (String)"size", (Object)"0x0");
        ArgTools.putPath((IArgs)argsInvisible, (String)"pageRange", (Object)"last");
        AnnotationDefinition annotDef = this.createAnnotationDefinition(fieldDefinition, (IArgs)argsInvisible);
        annotDef.setAnnotationType(AnnotationType.widget);
        return this.createFieldAnnotation(annotDef);
    }

    protected Shape createShape(EndorsementEvidence evidence) {
        Samples samples;
        IArgs argsData = ArgTools.toArgs((Object)evidence.getData());
        if (argsData.get("samples") == null) {
            throw new IllegalArgumentException("evidence data not supported");
        }
        Args args = Args.create();
        ArgTools.putPath((IArgs)args, (String)"type", (Object)"samples");
        ArgTools.putPath((IArgs)args, (String)"format", (Object)"jsSignature");
        ArgTools.putPath((IArgs)args, (String)"samples", (Object)ArgTools.getObject((IArgs)argsData, (String)"samples", null));
        ArgTools.putPath((IArgs)args, (String)"transform", (Object)ArgTools.getObject((IArgs)argsData, (String)"transform", null));
        Samples shape = samples = Samples.create((IArgs)args);
        shape.setPositionSpec(PointSpec.absolute((double)0.0, (double)0.0));
        shape.setSizeSpec(PointSpec.percent((double)100.0, (double)100.0));
        shape.setAlignment(RectAlignment.parse((String)"start;fill"));
        return shape;
    }

    protected PDAcroFormField detectAcroFormField(PDDocument doc, IFieldDefinition definition) {
        if (doc == null) {
            return null;
        }
        PDAcroForm acroForm = doc.getAcroForm();
        if (acroForm == null) {
            return null;
        }
        if (StringTools.isEmpty((String)definition.getFieldName())) {
            return null;
        }
        PDAcroFormField field = acroForm.getField(definition.getFieldName());
        if (field == null) {
            return null;
        }
        return field.getLogicalRoot();
    }

    public String getLastFieldName() {
        return this.lastFieldName;
    }

    public void setLastFieldName(String lastFieldName) {
        this.lastFieldName = lastFieldName;
    }
}

