/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget;

import de.intarsys.pdf.design.widget.IFieldReference;
import de.intarsys.pdf.design.widget.NewFieldReference;
import de.intarsys.tools.converter.Canonical;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.IConverter;
import de.intarsys.tools.preferences.PreferencesTools;
import java.awt.geom.Point2D;
import java.util.HashMap;

public class CanonicalFromIFieldReferenceConverter
implements IConverter<IFieldReference, String> {
    public String convert(IFieldReference source) throws ConversionException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (source instanceof NewFieldReference) {
            map.put("create", true);
            map.put("visible", source.isVisible());
            NewFieldReference newFieldReference = (NewFieldReference)source;
            map.put("adjustForRotate", Boolean.toString(newFieldReference.isAdjustForRotate()));
            HashMap<String, String> fontMap = new HashMap<String, String>();
            if (newFieldReference.getFontInfo().getFontName() != null) {
                fontMap.put("fontName", newFieldReference.getFontInfo().getFontName());
            }
            if (!fontMap.isEmpty()) {
                map.put("font", fontMap);
            }
            map.put("pageRange", newFieldReference.getPageSelector().asString());
            map.put("unit", newFieldReference.getDistanceUnit().getId());
            map.put("hAlign", newFieldReference.getHAlign().getId());
            map.put("vAlign", newFieldReference.getVAlign().getId());
            Point2D tempPoint = newFieldReference.getPositionScaled();
            map.put("position", tempPoint.getX() + "x" + tempPoint.getY());
            tempPoint = newFieldReference.getSizeScaled();
            map.put("size", tempPoint.getX() + "x" + tempPoint.getY());
        }
        return PreferencesTools.toString(map);
    }

    public Class<?> getSourceType() {
        return IFieldReference.class;
    }

    public Class<?> getTargetType() {
        return Canonical.class;
    }
}

