/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.markup;

import de.intarsys.pdf.app.annotation.AnnotationOutlet;
import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.app.page.PageSelector;
import de.intarsys.pdf.app.page.StaticSinglePageSelector;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.design.markup.CommonMarkupReference;
import de.intarsys.pdf.design.markup.PACKAGE;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDStampAnnotation;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class NewAnnotationReference
extends CommonMarkupReference {
    private static IMessageBundle Msg = PACKAGE.Messages;
    private Rectangle2D rect;
    private PageSelector pageSelector;

    public NewAnnotationReference(PDDocument doc, String subType) {
        this(doc, subType, new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f), 0);
        this.setVisible(false);
    }

    public NewAnnotationReference(PDDocument doc, String subType, Rectangle2D rect, int pageIndex) {
        super(doc);
        this.setSubType(subType);
        this.rect = rect;
        this.pageSelector = new StaticSinglePageSelector(pageIndex);
    }

    @Override
    protected PDAnnotation createAnnotation() {
        if (this.getDocument() == null) {
            return null;
        }
        PDAnnotation result = null;
        PageSelector tempSelector = this.getPageSelector();
        if (tempSelector == null) {
            tempSelector = new StaticSinglePageSelector(0);
        }
        Iterator<PDPage> it = tempSelector.getPages(this.getDocument());
        while (it.hasNext()) {
            PDPage page = it.next();
            result = this.createAnnotation(page);
        }
        return result;
    }

    protected PDAnnotation createAnnotation(PDPage page) {
        if ("Stamp".equals(this.getSubType())) {
            IAnnotationFactory factory = AnnotationOutlet.get().lookupAnnotationFactory(PDStampAnnotation.CN_Subtype_Stamp);
            try {
                PDAnnotation annot = factory.createAnnotation(page, this.getRect(), this.getAttributes());
                return annot;
            }
            catch (ObjectCreationException e) {
                throw new COSRuntimeException((Throwable)e);
            }
        }
        throw new IllegalArgumentException("type '" + this.getSubType() + "' not supported");
    }

    private Rectangle2D createRect() {
        float x = 0.0f;
        float y = 0.0f;
        float w = 0.0f;
        float h = 0.0f;
        if (this.getPosition() != null) {
            x = (float)this.getPosition().getX();
            y = (float)this.getPosition().getY();
        }
        if (this.getSize() != null) {
            w = (float)this.getSize().getX();
            h = (float)this.getSize().getY();
        }
        return new Rectangle2D.Float(x, y, w, h);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof NewAnnotationReference) {
            NewAnnotationReference otherRef = (NewAnnotationReference)obj;
            if (this.getPageSelector() == null && otherRef.getPageSelector() != null) {
                return false;
            }
            if (!this.getPageSelector().equals(otherRef.getPageSelector())) {
                return false;
            }
            if (this.getRect() == null && otherRef.getRect() != null) {
                return false;
            }
            return this.getRect().equals(otherRef.getRect());
        }
        return false;
    }

    @Override
    public String getLabel() {
        if (this.isVisible()) {
            return Msg.getString("NewAnnotationReference.labelVisible", new Object[0]);
        }
        return Msg.getString("NewAnnotationReference.labelInvisible", new Object[0]);
    }

    public PageSelector getPageSelector() {
        return this.pageSelector;
    }

    public Rectangle2D getRect() {
        if (this.rect == null) {
            this.rect = this.createRect();
        }
        return this.rect;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isNew() {
        return true;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setAnnotation(null);
    }

    public void setPageSelector(PageSelector pageSelector) {
        this.pageSelector = pageSelector;
    }

    @Override
    public void setPositionScaled(Point2D position) {
        super.setPositionScaled(position);
        this.rect = this.createRect();
    }

    public void setRect(Rectangle2D rect) {
        this.rect = rect;
    }

    @Override
    public void setSizeScaled(Point2D size) {
        super.setSizeScaled(size);
        this.rect = this.createRect();
    }
}

