/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.observation.micrometer;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.valueholder.INamedValue;
import de.intarsys.tools.valueholder.NamedValue;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MicrometerAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final Set<String> REQUIRED_OBSERVATION_KEYS = Set.of("id", "source", "created", "operation", "subcode");
    private static final Set<String> IGNORED_TAG_OBSERVATION_KEYS = Set.of("text", "app", "created", "id", "source", "code", "subcode");
    private static final String CODE_START = "start";
    private static final String CODE_OK = "ok";
    private static final String CODE_CANCEL = "cancel";
    private static final String CODE_FAIL = "fail";
    private static final String OUTCOME_TAG_NAME = "outcome";
    private static final int DEFAULT_CLEANUP_THRESHOLD = 1000;
    private static final Duration DEFAULT_MAX_TIMER_AGE = Duration.ofMinutes(30L);
    private static final Duration DEFAULT_DISTRIBUTION_STATISTIC_EXPIRY = Duration.ofSeconds(10L);
    private static final int DEFAULT_DISTRIBUTION_STATISTIC_BUFFER_LENGTH = 2;
    private final Map<TimerIdentifier, TimerContainer> timeContainersByIdentifier = new ConcurrentHashMap<TimerIdentifier, TimerContainer>();
    private final Logger Log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Duration maxTimerAge = DEFAULT_MAX_TIMER_AGE;
    private Duration distributionStatisticExpiry = DEFAULT_DISTRIBUTION_STATISTIC_EXPIRY;
    private int cleanupThreshold = 1000;
    private int distributionStatisticBufferLength = 2;
    @Autowired
    private MeterRegistry meterRegistry;

    public void append(ILoggingEvent iLoggingEvent) {
        try {
            if (iLoggingEvent.getArgumentArray() == null || iLoggingEvent.getArgumentArray().length == 0) {
                return;
            }
            if (this.timeContainersByIdentifier.size() >= this.cleanupThreshold) {
                this.cleanupTimers();
            }
            Map arguments = Arrays.stream(iLoggingEvent.getArgumentArray()).filter(INamedValue.class::isInstance).map(INamedValue.class::cast).filter(namedValue -> namedValue.get() != null).collect(Collectors.toMap(INamedValue::getName, namedValue -> namedValue.get().toString(), (existing, replacement) -> replacement, HashMap::new));
            if (!arguments.keySet().containsAll(REQUIRED_OBSERVATION_KEYS)) {
                Set missingKeys = REQUIRED_OBSERVATION_KEYS.stream().filter(key -> !arguments.containsKey(key)).collect(Collectors.toSet());
                this.Log.warn("Skipping event processing: missing required keys: {}", missingKeys);
                return;
            }
            String id = (String)arguments.get("id");
            String source = (String)arguments.get("source");
            String operation = (String)arguments.get("operation");
            String subcode = (String)arguments.get("subcode");
            String step = StringTools.trimToNull((String)((String)arguments.get("step")));
            String created = (String)arguments.get("created");
            arguments.keySet().removeAll(IGNORED_TAG_OBSERVATION_KEYS);
            TimerIdentifier identifier = new TimerIdentifier(id, operation, step);
            if (subcode.equals(CODE_START)) {
                this.processStartEvent(source, identifier, Long.parseLong(created));
            } else if (subcode.equals(CODE_OK) || subcode.equals(CODE_CANCEL) || subcode.equals(CODE_FAIL)) {
                this.processFinishEvent(identifier, subcode, arguments);
            } else {
                this.Log.warn("Skipping event processing: unknown subcode: '{}' from event: {}", (Object)subcode, (Object)iLoggingEvent);
            }
        }
        catch (Exception e) {
            this.Log.error("Append failed with an unexpected exception", (Throwable)e);
        }
    }

    private void cleanupTimers() {
        try {
            long now = System.currentTimeMillis();
            this.timeContainersByIdentifier.entrySet().removeIf(entry -> {
                TimerContainer container = (TimerContainer)entry.getValue();
                if (Duration.ofMillis(now - container.creationTime()).compareTo(this.maxTimerAge) > 0) {
                    this.Log.trace("Removing expired timer: {}", (Object)((TimerContainer)entry.getValue()).timerName());
                    return true;
                }
                return false;
            });
        }
        catch (Exception e) {
            this.Log.error("Error during lazy timer cleanup", (Throwable)e);
        }
    }

    private void logMonitorEvent(Timer timer, double durationSeconds, TimerContainer container) {
        Meter.Id meterIdObj = timer.getId();
        String meterName = meterIdObj.getName();
        Date startCreatedDate = new Date(container.creationTime());
        String formattedStartCreatedDate = new SimpleDateFormat("HH:mm:ss.SSS").format(startCreatedDate);
        ArrayList<NamedValue> namedValues = new ArrayList<NamedValue>();
        namedValues.add(new NamedValue("meter_name", (Object)meterName));
        namedValues.add(new NamedValue("started_timestamp", (Object)formattedStartCreatedDate));
        namedValues.add(new NamedValue("duration_seconds", (Object)String.valueOf(durationSeconds)));
        List meterTags = meterIdObj.getTags();
        for (Tag tag : meterTags) {
            String tagKey = "tag_" + tag.getKey().replace(".", "_");
            namedValues.add(new NamedValue(tagKey, (Object)tag.getValue()));
        }
        Object[] namedValuesArray = namedValues.toArray();
        String logMessage = meterIdObj + " started at " + formattedStartCreatedDate + " and took " + durationSeconds + "s";
        this.Log.debug(logMessage, namedValuesArray);
    }

    private void processFinishEvent(TimerIdentifier identifier, String subcode, Map<String, String> tagArguments) {
        try {
            TimerContainer container = this.timeContainersByIdentifier.remove(identifier);
            if (container == null) {
                this.Log.warn("No timer found for identifier: {}", (Object)identifier);
                return;
            }
            ArrayList<Tag> tags = new ArrayList<Tag>();
            if (tagArguments != null) {
                for (Map.Entry<String, String> entry : tagArguments.entrySet()) {
                    if (entry.getKey() == null || StringTools.isEmpty((String)entry.getValue())) continue;
                    tags.add(Tag.of((String)entry.getKey(), (String)entry.getValue()));
                }
            }
            Timer timer = Timer.builder((String)container.timerName()).tags(tags).tag(OUTCOME_TAG_NAME, subcode).distributionStatisticBufferLength(Integer.valueOf(this.distributionStatisticBufferLength)).distributionStatisticExpiry(this.distributionStatisticExpiry).register(this.meterRegistry);
            double durationSeconds = (double)container.sample().stop(timer) / 1.0E9;
            this.logMonitorEvent(timer, durationSeconds, container);
        }
        catch (Exception e) {
            this.Log.error("Error processing finish event for identifier: {}", (Object)identifier, (Object)e);
        }
    }

    private void processStartEvent(String source, TimerIdentifier identifier, long created) {
        try {
            Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
            String timerName = source.replace(".", "_");
            TimerContainer container = new TimerContainer(timerName, sample, created);
            this.timeContainersByIdentifier.put(identifier, container);
        }
        catch (Exception e) {
            this.Log.error("Error processing start event for identifier: {}", (Object)identifier, (Object)e);
        }
    }

    public void setCleanupThreshold(int cleanupThreshold) {
        this.cleanupThreshold = cleanupThreshold;
    }

    public void setDistributionStatisticBufferLength(int distributionStatisticBufferLength) {
        this.distributionStatisticBufferLength = distributionStatisticBufferLength;
    }

    public void setDistributionStatisticExpiry(Duration distributionStatisticExpiry) {
        this.distributionStatisticExpiry = distributionStatisticExpiry;
    }

    public void setMaxTimerAge(Duration maxTimerAge) {
        this.maxTimerAge = maxTimerAge;
    }

    public void stop() {
        this.timeContainersByIdentifier.clear();
        super.stop();
    }

    public record TimerIdentifier(String id, String operation, String step) {
    }

    public record TimerContainer(String timerName, Timer.Sample sample, long creationTime) {
    }
}

