/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.validation;

import de.intarsys.security.app.validation.CommonSignatureContainerValidator;
import de.intarsys.security.app.validation.IDigestProvider;
import de.intarsys.security.app.validation.ISignatureEntryValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.StaticDigestProvider;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.method.cms.signature.CMSSignatureContainer;
import de.intarsys.security.method.cms.signature.CMSSignatureEntry;
import de.intarsys.security.method.cms.validation.CMSSignatureDigestProvider;
import de.intarsys.security.method.cms.validation.NoReferenceDataProvidedException;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSDigest;
import de.intarsys.security.standard.validation.VSMathematicalSignature;
import de.intarsys.security.standard.validation.VSSignature;
import de.intarsys.security.standard.validation.VSSignatureContainer;
import de.intarsys.security.standard.validation.VSSignatureEntry;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class CMSSignatureContainerValidator
extends CommonSignatureContainerValidator {
    protected ISignatureEntryValidator createSignatureEntryValidator(ISignatureEntry signatureEntry, IValidationParameters parameters) {
        return ValidationContext.get().getSignatureEntryValidator();
    }

    public boolean isSigning(ISignatureContainer signatureContainer, IDigest digest) throws IOException {
        CMSSignatureContainer cmsSignatureContainer = (CMSSignatureContainer)signatureContainer;
        for (CMSSignatureEntry entry : cmsSignatureContainer.getEntries()) {
            ValidationParameters params;
            ISignatureEntryValidator entryValidator = this.createSignatureEntryValidator(entry, (IValidationParameters)(params = new ValidationParameters()));
            IVSSignatureEntry entryState = (IVSSignatureEntry)entryValidator.validate((ISignatureContainerEntry)entry, digest, (IValidationParameters)params);
            if (!entryState.isInvalid()) continue;
            return false;
        }
        return true;
    }

    protected IVSSignatureEntry validate(CMSSignatureEntry signatureEntry, IDigestProvider digestProvider, IValidationParameters parameters) {
        VSSignature signatureState = new VSSignature((IDigest)null);
        try {
            ISignatureEntryValidator entryValidator = this.createSignatureEntryValidator(signatureEntry, parameters);
            try {
                IDigest dataDigest = digestProvider.getDigest(signatureEntry.getHashAlgorithmSpec());
                return (IVSSignatureEntry)entryValidator.validate((ISignatureContainerEntry)signatureEntry, dataDigest, parameters);
            }
            catch (NoReferenceDataProvidedException e) {
                IVSSignatureEntry entryState = (IVSSignatureEntry)entryValidator.validate((ISignatureContainerEntry)signatureEntry, null, parameters);
                return entryState;
            }
        }
        catch (NoSuchAlgorithmException e) {
            IValidationMessage message = CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN((Exception)e, (String)signatureEntry.getHashAlgorithmSpec().getAlgorithm().getCanonicalName());
            signatureState.setSignatureState(VSMathematicalSignature.createInvalid((IValidationMessage)message));
            signatureState.addDigestState((IVSDigest)VSDigest.createInvalid((IValidationMessage)message));
        }
        catch (IOException e) {
            IValidationMessage message = CommonValidationMessages.ERROR_IO((Exception)e);
            signatureState.setSignatureState(VSMathematicalSignature.createInvalid((IValidationMessage)message));
            signatureState.addDigestState((IVSDigest)VSDigest.createInvalid((IValidationMessage)message));
        }
        VSSignatureEntry entryState = new VSSignatureEntry((ISignatureEntry)signatureEntry);
        entryState.setSignatureState((IVSSignature)signatureState);
        return entryState;
    }

    public IVSSignatureContainer validate(ISignatureContainer signatureContainer, IDigest digest, IValidationParameters parameters) {
        CMSSignatureContainer cmsSignatureContainer = (CMSSignatureContainer)signatureContainer;
        VSSignatureContainer containerState = new VSSignatureContainer(signatureContainer);
        CMSSignatureDigestProvider digestProvider = null;
        digestProvider = digest == null ? new CMSSignatureDigestProvider(cmsSignatureContainer) : new StaticDigestProvider(digest);
        for (ISignatureContainerEntry iSignatureContainerEntry : cmsSignatureContainer.getEntries()) {
            CMSSignatureEntry signatureEntry = (CMSSignatureEntry)iSignatureContainerEntry;
            IVSSignatureEntry entryState = this.validate(signatureEntry, (IDigestProvider)digestProvider, parameters);
            containerState.addEntryState((IVSSignatureContainerEntry)entryState);
        }
        return containerState;
    }
}

