/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.signature;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.x509.attr.Attributes;
import de.intarsys.security.signature.attribute.IAttribute;
import de.intarsys.security.signature.attribute.IAttributeMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;

public class AttributeMap
implements IAttributeMap {
    private final Attributes cmsAttributes;

    public AttributeMap(Attributes cmsAttributes) {
        assert (cmsAttributes != null);
        this.cmsAttributes = cmsAttributes;
    }

    public boolean contains(String oid) {
        return this.cmsAttributes.get(oid) != null;
    }

    public IAttribute get(String oid) throws IOException {
        Attribute cmsAttribute = this.cmsAttributes.get(oid);
        if (cmsAttribute != null) {
            return (IAttribute)ASN1Tools.decodeObject((ASN1Encodable)cmsAttribute, IAttribute.class);
        }
        return null;
    }

    public Set<String> getOIDs() {
        HashSet<String> types = new HashSet<String>();
        for (int i = 0; i < this.cmsAttributes.size(); ++i) {
            Attribute attr = this.cmsAttributes.get(i);
            types.add(attr.getAttrType());
        }
        return types;
    }
}

