/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.encryption;

import de.intarsys.asn1.cms.EncryptedKey;
import de.intarsys.asn1.cms.KeyEncryptionAlgorithmIdentifier;
import de.intarsys.asn1.cms.KeyTransRecipientInfo;
import de.intarsys.asn1.cms.RecipientIdentifier;
import de.intarsys.asn1.cms.RecipientInfo;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.app.crypt.IEncryptedData;
import de.intarsys.security.app.encryption.IEncryptor;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.cms.encryption.CommonPKCS7RecipientInfoEncoder;
import de.intarsys.security.method.cms.encryption.EncryptorException;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;

public class PKCS7RecipientInfoEncoderRSA
extends CommonPKCS7RecipientInfoEncoder {
    @Override
    protected RecipientInfo basicEncode(byte[] cek, IEncryptor encryptor) throws EncryptorException {
        try {
            IEncryptedData encryptedData = encryptor.encrypt(cek);
            RecipientInfo recipientInfo = (RecipientInfo)RecipientInfo.FACTORY.createNew();
            KeyTransRecipientInfo keyTransRecipientInfo = this.encodeKeyTransRecipientInfo(encryptedData, encryptor.getCertificate());
            recipientInfo.setKeyTransRecipientInfo(keyTransRecipientInfo);
            return recipientInfo;
        }
        catch (Exception e) {
            throw new EncryptorException(e);
        }
    }

    protected EncryptedKey encodeEncryptedKey(IEncryptedData encryptedData) throws EncryptorException {
        try {
            InputStream is = encryptedData.getLocator().getInputStream();
            byte[] bytes = StreamTools.toByteArray((InputStream)is);
            return EncryptedKey.create((byte[])bytes);
        }
        catch (IOException e) {
            throw new EncryptorException(e);
        }
    }

    protected KeyTransRecipientInfo encodeKeyTransRecipientInfo(IEncryptedData encryptedData, IX509PublicKeyCertificate certificate) throws EncryptorException {
        KeyTransRecipientInfo keyTransRecipientInfo = (KeyTransRecipientInfo)KeyTransRecipientInfo.FACTORY.createNew();
        keyTransRecipientInfo.setEncryptedKey(this.encodeEncryptedKey(encryptedData));
        keyTransRecipientInfo.setKeyEncryptionAlgorithmIdentifier(KeyEncryptionAlgorithmIdentifier.create((String)encryptedData.getAlgorithmOID()));
        if (encryptedData.getAlgorithmParameters() != null) {
            ASN1Primitive params;
            try {
                params = ASN1Tools.create((byte[])encryptedData.getAlgorithmParameters());
            }
            catch (IOException e) {
                throw new EncryptorException(e);
            }
            keyTransRecipientInfo.getKeyEncryptionAlgorithmIdentifier().setParameters((ASN1Encodable)params);
        }
        RecipientIdentifier recipientIdentifier = (RecipientIdentifier)RecipientIdentifier.FACTORY.createNew();
        recipientIdentifier.setIssuerAndSerialNumber(this.encodeIssuerAndSerialNumber(certificate));
        keyTransRecipientInfo.setRecipientIdentifier(recipientIdentifier);
        return keyTransRecipientInfo;
    }
}

