/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.encoder;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.UnsignedAttributes;
import de.intarsys.asn1.cms.attr.AttributeTimestamp;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.app.timestamp.ITimestampRequest;
import de.intarsys.security.app.timestamp.ITimestampResponse;
import de.intarsys.security.app.timestamp.PlainTimestampRequest;
import de.intarsys.security.method.cms.attribute.encoder.IAttributeEncoder;
import de.intarsys.security.method.cms.signature.CMSBasedSignatureContainer;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.timestamp.ITimestampSupport;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampEncoder
implements IAttributeEncoder {
    private static final Logger Log = LoggerFactory.getLogger(TimestampEncoder.class);
    private final ITimestampCreator timestampCreator;
    private ITimestampToken timestamp;
    private boolean enforceTimestamp;
    private String digestAlgorithmName = "SHA256";

    public TimestampEncoder(ITimestampCreator timestampCreator) {
        this.timestampCreator = timestampCreator;
    }

    protected boolean containsSignatureTimestamp(SignerInfo signerInfo) {
        UnsignedAttributes unsignedAttrs = signerInfo.getUnsignedAttrs();
        if (unsignedAttrs == null) {
            return false;
        }
        Attribute attribute = unsignedAttrs.get("1.2.840.113549.1.9.16.2.14");
        return attribute != null;
    }

    protected Attribute createAttribute() {
        AttributeTimestamp attrTimestamp = (AttributeTimestamp)AttributeTimestamp.FACTORY.createNew();
        CMSBasedSignatureContainer pkcs7 = (CMSBasedSignatureContainer)this.timestamp.getSignatureContainer();
        attrTimestamp.addTimestamp(pkcs7.getCms());
        return attrTimestamp;
    }

    protected ITimestampToken createFromSignatureData(ICMSSignatureContainerBuilder builder, ISignatureData signature) {
        if (signature instanceof ITimestampSupport) {
            return ((ITimestampSupport)signature).getTimestamp();
        }
        return null;
    }

    protected ITimestampToken createFromTimestampCreator(CMS cms, SignerInfo signerInfo) throws IOException {
        IDigester digester;
        if (this.getTimestampCreator() == null) {
            return null;
        }
        byte[] signature = signerInfo.getSignature().getBytes();
        try {
            digester = DigestTools.createDigester((String)this.getDigestAlgorithmName());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
        IDigest digest = digester.digest(signature);
        try {
            ITimestampResponse response = this.getTimestampCreator().createTimestamp((ITimestampRequest)new PlainTimestampRequest(digest));
            if (response.getTimestamp() == null) {
                throw new IOException("timestamp attribute could not be created");
            }
            return response.getTimestamp();
        }
        catch (SecurityApplicationException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public Attribute getAttribute(ICMSSignatureContainerBuilder builder, CMS cms, SignerInfo signerInfo, ISignatureData signatureData) throws IOException {
        if (this.containsSignatureTimestamp(signerInfo)) {
            return null;
        }
        if (this.timestamp == null) {
            this.timestamp = this.createFromSignatureData(builder, signatureData);
            if (this.timestamp == null) {
                this.timestamp = this.createFromTimestampCreator(cms, signerInfo);
            }
            if (this.timestamp == null) {
                if (this.isEnforceTimestamp()) {
                    throw new IOException("Signature timestamp required, but none available!");
                }
                return null;
            }
        }
        return this.createAttribute();
    }

    public String getDigestAlgorithmName() {
        return this.digestAlgorithmName;
    }

    public ITimestampCreator getTimestampCreator() {
        return this.timestampCreator;
    }

    public boolean isEnforceTimestamp() {
        return this.enforceTimestamp;
    }

    @Override
    public boolean isToBeSigned() {
        return false;
    }

    public void setDigestAlgorithmName(String digestAlgorithmName) {
        this.digestAlgorithmName = digestAlgorithmName;
    }

    public void setEnforceTimestamp(boolean enforceTimestamp) {
        this.enforceTimestamp = enforceTimestamp;
    }
}

