/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.encoder;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.attr.AttributeSigningTime;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.security.app.IApplication;
import de.intarsys.security.method.cms.attribute.encoder.IAttributeEncoder;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.tools.date.TimeEnvironment;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1UTCTime;

public class SigningTimeEncoder
implements IAttributeEncoder {
    @Override
    public Attribute getAttribute(ICMSSignatureContainerBuilder builder, CMS cms, SignerInfo signerInfo, ISignatureData signatureData) {
        AttributeSigningTime result = (AttributeSigningTime)AttributeSigningTime.FACTORY.createNew();
        long offset = this.getSignatureTimeOffset(builder);
        Instant now = TimeEnvironment.get().now();
        ASN1UTCTime time = new ASN1UTCTime(Date.from(now.plusMillis(offset)));
        result.setTime(time);
        return result;
    }

    protected long getSignatureTimeOffset(ICMSSignatureContainerBuilder builder) {
        return Optional.ofNullable(builder).map(ICMSSignatureContainerBuilder::getSigner).map(IApplication::getDevice).map(device -> {
            try {
                return (Long)device.getValue("pdfSignatureTimeOffset");
            }
            catch (Exception e) {
                return null;
            }
        }).orElse(0L);
    }

    @Override
    public boolean isToBeSigned() {
        return true;
    }
}

