/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.form.model;

import de.intarsys.tools.form.model.CheckboxField;
import de.intarsys.tools.form.model.CommonField;
import de.intarsys.tools.form.model.DateTimeField;
import de.intarsys.tools.form.model.FieldTypes;
import de.intarsys.tools.form.model.ImageField;
import de.intarsys.tools.form.model.NumberField;
import de.intarsys.tools.form.model.SignatureDepictionField;
import de.intarsys.tools.form.model.TextField;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;

public class FieldType {
    private String id;
    private String label;
    private String icon;
    private IArgs template;

    public FieldType() {
    }

    public FieldType(String id) {
        this.id = id;
    }

    public FieldType(String id, IArgs template) {
        this.id = id;
        this.template = template;
    }

    public CommonField createField(IArgs args) {
        Args tempArgs = this.template == null ? Args.create() : this.template.copy();
        ArgTools.putAllDeep((IArgs)tempArgs, (IArgs)args);
        if (FieldTypes.TEXT.getId().equals(this.getId())) {
            return new TextField(this, (IArgs)tempArgs);
        }
        if (FieldTypes.NUMBER.getId().equals(this.getId())) {
            return new NumberField(this, (IArgs)tempArgs);
        }
        if (FieldTypes.DATETIME.getId().equals(this.getId())) {
            return new DateTimeField(this, (IArgs)tempArgs);
        }
        if (FieldTypes.CHECKBOX.getId().equals(this.getId())) {
            return new CheckboxField(this, (IArgs)tempArgs);
        }
        if (FieldTypes.IMAGE.getId().equals(this.getId())) {
            return new ImageField(this, (IArgs)tempArgs);
        }
        if (FieldTypes.SIGNATURE.getId().equals(this.getId())) {
            return new SignatureDepictionField(this, (IArgs)tempArgs);
        }
        throw new IllegalArgumentException("invalid field type " + this.getId());
    }

    public String getIcon() {
        return this.icon;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public IArgs getTemplate() {
        return this.template;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setTemplate(IArgs template) {
        this.template = template;
    }
}

