/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.content;

import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.http.content.HttpEntityApplicationOctetEncoder;
import de.intarsys.tools.http.content.HttpEntityEncoder;
import de.intarsys.tools.http.content.HttpEntityMultipartFormDataEncoder;
import de.intarsys.tools.http.content.IHttpEntityEncoder;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;

public class HttpEntityAutoEncoder
extends HttpEntityEncoder {
    @Override
    protected HttpEntity basicEncode(Object value) throws IOException {
        IHttpEntityEncoder encoder = this.detectEncoder(value);
        if (encoder == null) {
            throw new IOException("no encoder for " + value);
        }
        return encoder.encode(value);
    }

    protected IHttpEntityEncoder detectEncoder(Object value) {
        if (value instanceof IArgs) {
            return this.detectEncoderArgs((IArgs)value);
        }
        if (value instanceof Map) {
            return this.detectEncoderMap((Map)value);
        }
        if (value instanceof Object[]) {
            return this.detectEncoderArray((Object[])value);
        }
        if (value instanceof Collection) {
            return this.detectEncoderCollection((Collection)value);
        }
        if (value instanceof Iterator) {
            return this.detectEncoderIterator((Iterator)value);
        }
        if (value instanceof File) {
            return this.getEncoderBinary();
        }
        if (value instanceof FileLocator) {
            return this.getEncoderBinary();
        }
        if (value instanceof ILocator) {
            return this.getEncoderBinary();
        }
        if (value instanceof ILocatorSupport) {
            return this.getEncoderBinary();
        }
        if (value instanceof byte[]) {
            return this.getEncoderBinary();
        }
        return this.getEncoderDefault();
    }

    protected IHttpEntityEncoder detectEncoderArgs(IArgs args) {
        Iterator it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = (IArgs.IBinding)it.next();
            Object value = binding.getValue();
            IHttpEntityEncoder encoder = this.detectEncoder(value);
            if (!this.isEnforceMultipart(encoder)) continue;
            return this.getEncoderCompositeMultipart();
        }
        return this.getEncoderCompositeUrlEncoded();
    }

    protected IHttpEntityEncoder detectEncoderArray(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            Object value = array[i];
            IHttpEntityEncoder encoder = this.detectEncoder(value);
            if (!this.isEnforceMultipart(encoder)) continue;
            return this.getEncoderCompositeMultipart();
        }
        return this.getEncoderCompositeUrlEncoded();
    }

    protected IHttpEntityEncoder detectEncoderCollection(Collection collection) {
        for (Object value : collection) {
            IHttpEntityEncoder encoder = this.detectEncoder(value);
            if (!this.isEnforceMultipart(encoder)) continue;
            return this.getEncoderCompositeMultipart();
        }
        return this.getEncoderCompositeUrlEncoded();
    }

    protected IHttpEntityEncoder detectEncoderIterator(Iterator it) {
        return this.getEncoderCompositeMultipart();
    }

    protected IHttpEntityEncoder detectEncoderMap(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            IHttpEntityEncoder encoder = this.detectEncoder(value);
            if (!this.isEnforceMultipart(encoder)) continue;
            return this.getEncoderCompositeMultipart();
        }
        return this.getEncoderCompositeUrlEncoded();
    }

    @Override
    public String getContentType() {
        return "auto";
    }

    protected IHttpEntityEncoder getEncoderBinary() {
        return HttpEntityEncoder.lookupEncoder("application/octet-stream");
    }

    protected IHttpEntityEncoder getEncoderCompositeMultipart() {
        return HttpEntityEncoder.lookupEncoder("multipart/form-data");
    }

    protected IHttpEntityEncoder getEncoderCompositeUrlEncoded() {
        return HttpEntityEncoder.lookupEncoder("application/x-www-form-urlencoded");
    }

    protected IHttpEntityEncoder getEncoderDefault() {
        return HttpEntityEncoder.lookupEncoder("text/plain");
    }

    protected boolean isEnforceMultipart(IHttpEntityEncoder encoder) {
        if (encoder instanceof HttpEntityMultipartFormDataEncoder) {
            return true;
        }
        return encoder instanceof HttpEntityApplicationOctetEncoder;
    }
}

