/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.content;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.http.content.HttpEntityEncoder;
import de.intarsys.tools.http.httpcomponents.FileEntity;
import de.intarsys.tools.http.httpcomponents.LocatorEntity;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;

public class HttpEntityApplicationOctetEncoder
extends HttpEntityEncoder {
    @Override
    protected HttpEntity basicEncode(Object value) throws IOException {
        return this.createEntity(value);
    }

    protected HttpEntity createEntity(Object value) throws IOException {
        if (value instanceof File) {
            File file = (File)value;
            FileEntity entity = new FileEntity(file);
            entity.setContentType("application/octet-stream");
            return entity;
        }
        if (value instanceof FileLocator) {
            File file = ((FileLocator)value).getFile();
            FileEntity entity = new FileEntity(file);
            entity.setContentType("application/octet-stream");
            return entity;
        }
        if (value instanceof ILocator) {
            LocatorEntity entity = new LocatorEntity((ILocator)value);
            entity.setContentType("application/octet-stream");
            return entity;
        }
        if (value instanceof ILocatorSupport) {
            LocatorEntity entity = new LocatorEntity(((ILocatorSupport)value).getLocator());
            entity.setContentType("application/octet-stream");
            return entity;
        }
        if (value instanceof byte[]) {
            ByteArrayEntity entity = new ByteArrayEntity((byte[])value);
            entity.setContentType("application/octet-stream");
            return entity;
        }
        if (value == null) {
            ByteArrayEntity entity = new ByteArrayEntity(new byte[0]);
            entity.setContentType("application/octet-stream");
            return entity;
        }
        try {
            String tempString = (String)ConverterRegistry.get().convert(value, String.class);
            ByteArrayEntity entity = new ByteArrayEntity(tempString.getBytes());
            entity.setContentType("application/octet-stream");
            return entity;
        }
        catch (ConversionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getContentType() {
        return "application/octet-stream";
    }
}

