/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ssl;

import de.intarsys.tools.ssl.DelegatingSslSocketFactory;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class DelegatingSslContextSpi
extends SSLContextSpi {
    private final SSLContext sslContext;
    private final SSLSocketFactory sslSocketFactory;

    public DelegatingSslContextSpi(SSLContext sslContext) {
        this.sslContext = sslContext;
        this.sslSocketFactory = new DelegatingSslSocketFactory(sslContext.getSocketFactory());
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() {
        return this.sslContext.createSSLEngine();
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String host, int port) {
        return this.sslContext.createSSLEngine(host, port);
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        return this.sslContext.getClientSessionContext();
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        return this.sslContext.getServerSessionContext();
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        return this.sslContext.getServerSocketFactory();
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
        this.sslContext.init(km, tm, sr);
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }
}

