/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.io;

import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.claptz.impl.StandardInstrumentRegistry;
import de.intarsys.claptz.io.CommonInstrumentStore;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.file.IPathFilter;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.locator.ClassLoaderResourceLocatorFactory;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.RelativeLocatorFactory;
import de.intarsys.tools.monitor.ITrace;
import de.intarsys.tools.monitor.TimeMonitor;
import de.intarsys.tools.reflect.ClassTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarInstrumentStore
extends CommonInstrumentStore {
    public static final String DEFAULT_PATTERN = "instrument/INSTRUMENT-INF/instrument.xml";
    private static final Logger Log = LoggerFactory.getLogger(JarInstrumentStore.class);
    private static TimeMonitor Monitor = new TimeMonitor(ClassTools.getUnqualifiedName(JarInstrumentStore.class));
    private final ClassLoader classLoader;
    private String pattern;

    public JarInstrumentStore(ClassLoader classLoader) {
        this(classLoader, DEFAULT_PATTERN, IPathFilter.ANY_FILTER);
    }

    public JarInstrumentStore(ClassLoader classLoader, String filenamePattern, IPathFilter filter) {
        super(filter);
        this.classLoader = classLoader;
        this.setPattern(filenamePattern);
    }

    @Override
    public void flush(StandardInstrument instrument) throws IOException {
        throw new IOException("can't write to classpath");
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void load(StandardInstrumentRegistry registry) throws InstrumentRegistryException {
        Enumeration<URL> urls;
        ITrace trace = Monitor.attach();
        try {
            urls = this.getClassLoader().getResources(this.getPattern());
        }
        catch (IOException exception) {
            throw new InstrumentRegistryException("error loading instruments matching '" + this.getPattern() + "'");
        }
        Log.trace("JarInstrumentStore enumerate {}", (Object)this.getPattern());
        while (urls.hasMoreElements()) {
            this.load(registry, urls.nextElement());
        }
        trace.stop();
    }

    protected void load(StandardInstrumentRegistry registry, URL url) throws InstrumentRegistryException {
        Log.trace("JarInstrumentStore load {}", (Object)url);
        try (InputStream is = url.openStream();){
            StandardInstrument instrument = new StandardInstrument(registry, this);
            String urlString = url.toExternalForm();
            String urlLocatorString = urlString.substring(0, urlString.length() - this.getPattern().length());
            URLClassLoader instrumentLocatorClassLoader = new URLClassLoader(new URL[]{new URL(urlLocatorString)});
            String urlBinaryString = urlLocatorString + "instrument/INSTRUMENT-INF/classes/";
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            if (parent == null) {
                parent = ClassLoader.getSystemClassLoader();
            }
            URLClassLoader instrumentBinaryClassLoader = new URLClassLoader(new URL[]{new URL(urlBinaryString)}, parent);
            ClassLoaderResourceLocatorFactory locatorFactory = new ClassLoaderResourceLocatorFactory((ClassLoader)instrumentLocatorClassLoader);
            locatorFactory = new RelativeLocatorFactory((ILocatorFactory)locatorFactory, "instrument");
            instrument.setLocatorFactory((ILocatorFactory)locatorFactory);
            instrument.setClassLoader(instrumentBinaryClassLoader);
            instrument.setBaseDir(new File("."));
            IDocument doc = ElementFactory.get().parse(is);
            if (doc instanceof IStringEvaluatorAccess) {
                ScopedResolver resolver = ScopedResolver.create((IStringEvaluator[])new IStringEvaluator[]{instrument.getExpressionEvaluator(), ExpressionEvaluator.get((Mode)Mode.TRUSTED)});
                ((IStringEvaluatorAccess)doc).setStringEvaluator((IStringEvaluator)resolver);
            }
            instrument.configure(doc.getRootElement());
            String id = instrument.getId();
            IInstrument tempInstrument = registry.lookupInstrument(id);
            if (tempInstrument == null) {
                registry.registerInstrument(instrument);
                Log.debug("instrument '{}' at '{}' defined", (Object)id, (Object)url);
            } else {
                Log.warn("instrument '{}' at '{}' redefines {}, skipped", new Object[]{id, url, tempInstrument});
            }
        }
        catch (Exception ex) {
            throw new InstrumentRegistryException("error loading instrument at '" + url + "'", ex);
        }
    }

    public void setPattern(String locationPattern) {
        this.pattern = locationPattern;
    }
}

