/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.io;

import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.claptz.impl.StandardInstrumentRegistry;
import de.intarsys.claptz.io.CommonInstrumentStore;
import de.intarsys.claptz.io.IInstrumentStore;
import de.intarsys.claptz.io.InstrumentSerializer;
import de.intarsys.claptz.io.PACKAGE;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.file.IPathFilter;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.locator.FileLocatorFactory;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.sax.SAXTools;
import de.intarsys.tools.serialize.SerializationContext;
import de.intarsys.tools.serialize.xml.XMLSerializationContext;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryInstrumentStore
extends CommonInstrumentStore {
    private static final int BUFFER_SIZE = 10000;
    public static final String META_DEFINITION = "instrument.xml";
    public static final String META_DIRECTORY = "INSTRUMENT-INF";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(DirectoryInstrumentStore.class);
    private SAXParser parser;
    private int defaultStartLevel = 50;
    private final File file;
    private List<IInstrument> loaded = new ArrayList<IInstrument>();

    public static IInstrumentStore getLocal() {
        return new DirectoryInstrumentStore(new File(FileEnvironment.get().getProfileDir(), "instruments"));
    }

    public DirectoryInstrumentStore(File file) {
        this(file, IPathFilter.ANY_FILTER);
    }

    public DirectoryInstrumentStore(File file, IPathFilter filter) {
        super(filter);
        Objects.requireNonNull(file, "file cannot be null");
        this.file = file;
        try {
            this.parser = SAXTools.createSecureParserFactory().newSAXParser();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error creating SAXParser", e);
        }
    }

    @Override
    public void flush(StandardInstrument instrument) throws IOException {
        File tempBaseDir = instrument.getBaseDir();
        if (tempBaseDir == null) {
            tempBaseDir = new File(this.getFile(), instrument.getId());
        }
        this.save(instrument, tempBaseDir);
    }

    public int getDefaultStartLevel() {
        return this.defaultStartLevel;
    }

    public File getFile() {
        return this.file;
    }

    public List<IInstrument> getLoaded() {
        return this.loaded;
    }

    protected SAXParser getParser() {
        return this.parser;
    }

    protected boolean isInstrumentHome(File home) {
        File metaDir = new File(home, META_DIRECTORY);
        File configFile = new File(metaDir, META_DEFINITION);
        return configFile.exists();
    }

    @Override
    public void load(StandardInstrumentRegistry registry) throws InstrumentRegistryException {
        Log.trace("DirectoryInstrumentStore enumerate {}, {}", (Object)this.getFile());
        this.loadAllInstruments(registry, this.file, this.getFilter());
    }

    protected void loadAllInstruments(StandardInstrumentRegistry registry, File base, IPathFilter filter) throws InstrumentRegistryException {
        if (this.isInstrumentHome(base)) {
            this.loadInstrument(registry, base);
        } else {
            if (!base.isDirectory()) {
                return;
            }
            Object[] instrumentDirs = base.list();
            if (instrumentDirs == null || instrumentDirs.length == 0) {
                return;
            }
            Arrays.sort(instrumentDirs);
            for (int i = 0; i < instrumentDirs.length; ++i) {
                Object path = instrumentDirs[i];
                if (!filter.accept((String)path)) continue;
                this.loadInstrument(registry, new File(base, (String)path));
            }
        }
    }

    public void loadInstrument(StandardInstrumentRegistry registry, File home) throws InstrumentRegistryException {
        File metaDir = new File(home, META_DIRECTORY);
        File configFile = new File(metaDir, META_DEFINITION);
        this.loadInstrument(registry, home, configFile);
    }

    protected void loadInstrument(StandardInstrumentRegistry registry, File base, File file) throws InstrumentRegistryException {
        Log.trace("DirectoryInstrumentStore load {}", (Object)file);
        try (FileInputStream fis2 = new FileInputStream(file);
             BufferedInputStream is = new BufferedInputStream(fis2, 10000);){
            StandardInstrument instrument = new StandardInstrument(registry, this);
            instrument.setStartLevel(this.getDefaultStartLevel());
            FileLocatorFactory locatorFactory = new FileLocatorFactory(base);
            instrument.setLocatorFactory((ILocatorFactory)locatorFactory);
            instrument.setBaseDir(base);
            IDocument doc = ElementFactory.get().parse((InputStream)is);
            if (doc instanceof IStringEvaluatorAccess) {
                ScopedResolver resolver = ScopedResolver.create((IStringEvaluator[])new IStringEvaluator[]{instrument.getExpressionEvaluator(), ExpressionEvaluator.get((Mode)Mode.TRUSTED)});
                ((IStringEvaluatorAccess)doc).setStringEvaluator((IStringEvaluator)resolver);
            }
            instrument.configure(doc.getRootElement());
            String id = instrument.getId();
            IInstrument tempInstrument = registry.lookupInstrument(id);
            if (tempInstrument == null) {
                registry.registerInstrument(instrument);
                Log.debug("instrument '{}' at '{}' defined", (Object)id, (Object)file);
            } else {
                Log.warn("instrument '{}' at '{}' redefines {}", new Object[]{id, file, tempInstrument});
            }
            this.loaded.add(instrument);
        }
        catch (FileNotFoundException fis2) {
        }
        catch (IOException e) {
            throw new InstrumentRegistryException(Msg.getString("DirectoryInstrumentStore.ExLoadingDefinition", new Object[]{base.getAbsolutePath(), "line 0, column 0: " + e.getMessage()}), e);
        }
        catch (Exception e) {
            throw new InstrumentRegistryException(Msg.getString("DirectoryInstrumentStore.ExLoadingDefinition", new Object[]{base.getAbsolutePath(), e.getMessage()}), e);
        }
    }

    protected void save(StandardInstrument instrument, File dir) throws IOException {
        instrument.setBaseDir(dir);
        File tempInstrumentDir = new File(dir, META_DIRECTORY);
        File tempInstrumentFile = new File(tempInstrumentDir, META_DEFINITION);
        FileTools.mkdirs((File)tempInstrumentDir);
        try (FileOutputStream os = new FileOutputStream(tempInstrumentFile);){
            XMLSerializationContext context = new XMLSerializationContext((OutputStream)os, true);
            InstrumentSerializer serializer = new InstrumentSerializer((SerializationContext)context);
            serializer.serialize(instrument);
        }
    }

    public void setDefaultStartLevel(int defaultStartLevel) {
        this.defaultStartLevel = defaultStartLevel;
    }
}

