/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.extension.runtime;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.tools.bean.BeanContainer;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.StringTools;

public class BeanInstaller
extends ExtensionPointHandlerAdapter {
    private static final String ATTR_BEAN_ROLE = "bean-role";
    private static final String ATTR_BEAN_REGISTRY = "bean-registry";
    private static final String ATTR_BEAN_PROXY = "bean-proxy";
    private static final String ATTR_BEAN_ID = "bean-id";
    public static final String XP_BEANS = "de.intarsys.beans";
    public static final String XE_OBJECT = "object";
    public static final String XE_CLASS = "class";

    @Override
    protected Object basicInstallInsert(IExtension extension, IElement element) {
        if (XE_OBJECT.equals(element.getName())) {
            try {
                String id = element.attributeValue(ATTR_BEAN_ID, null);
                String beanClassAttribute = null;
                if (element.attributeValue(ATTR_BEAN_PROXY, null) != null) {
                    beanClassAttribute = ATTR_BEAN_PROXY;
                }
                Object bean = ElementTools.createObject((IElement)element, (String)beanClassAttribute, Object.class, (Object)extension.getProvider(), (IArgs)Args.create());
                String role = element.attributeValue(ATTR_BEAN_ROLE, null);
                BeanContainer.get().registerBean(id, role, bean);
                String registryId = element.attributeValue(ATTR_BEAN_REGISTRY, null);
                if (!StringTools.isEmpty((String)registryId)) {
                    Object registry = BeanContainer.get().lookupBean(registryId, Object.class);
                    if (registry == null) {
                        throw new ObjectCreationException("registry '" + registryId + "' not found");
                    }
                    ObjectTools.register((Object)registry, (Object)bean);
                }
                return bean;
            }
            catch (Exception e) {
                throw ExceptionTools.wrap((Throwable)e);
            }
        }
        if (XE_CLASS.equals(element.getName())) {
            try {
                Class bean = ElementTools.createClass((IElement)element, (String)"name", Class.class, (Object)extension.getProvider());
                return bean;
            }
            catch (Exception e) {
                throw ExceptionTools.wrap((Throwable)e);
            }
        }
        return super.basicInstallInsert(extension, element);
    }

    @Override
    protected Object basicInstallUpdate(IExtension extension, IElement element) {
        String id;
        if (XE_OBJECT.equals(element.getName()) && (id = element.attributeValue(ATTR_BEAN_ID, null)) != null) {
            BeanContainer.get().unregisterBean(id);
        }
        return this.basicInstallInsert(extension, element);
    }

    @Override
    protected void basicUninstall() {
        super.basicUninstall();
        BeanContainer.get().shutdown();
    }
}

