/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.container;

import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.container.InstrumentProvider;
import de.intarsys.claptz.impl.StandardInstrumentRegistry;
import de.intarsys.claptz.io.DirectoryInstrumentStore;
import de.intarsys.tools.cli.CLICommandline;
import de.intarsys.tools.cli.ICLICommandline;
import de.intarsys.tools.cli.ICLIOption;
import de.intarsys.tools.environment.file.FileEnvironment;
import java.io.File;

public class InstrumentProfileProvider
extends InstrumentProvider {
    private static final String DIR_INSTRUMENTS = "instruments";
    public static final int START_LEVEL_PROFILE = 90;
    public static final String CLIOPT_ITSTRICT = "itstrict";
    private static final String ARG_IT_STRICT = "itStrict";
    private boolean instrumentDirsStrict;

    @Override
    public void configureCLI(ICLICommandline icliCommandline) {
        super.configureCLI(icliCommandline);
        ICLIOption optIstrict = CLICommandline.get().getOption(CLIOPT_ITSTRICT);
        if (optIstrict != null) {
            optIstrict.setProcessed(true);
            this.setInstrumentDirsStrict(true);
        }
    }

    public boolean isInstrumentDirsStrict() {
        return this.instrumentDirsStrict;
    }

    @Override
    public void load(StandardInstrumentRegistry instrumentRegistry) throws InstrumentRegistryException {
        if (this.isInstrumentDirsStrict()) {
            return;
        }
        File tempDir = new File(FileEnvironment.get().getProfileDir(), DIR_INSTRUMENTS);
        DirectoryInstrumentStore store = new DirectoryInstrumentStore(tempDir);
        store.setDefaultStartLevel(90);
        instrumentRegistry.load(store);
    }

    public void setInstrumentDirsStrict(boolean instrumentDirsStrict) {
        this.instrumentDirsStrict = instrumentDirsStrict;
    }
}

