/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.common;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.impl.ExtensionPointHandlerAdapter;
import de.intarsys.document.common.DocumentTypeProxy;
import de.intarsys.document.model.DocumentOutlet;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.string.StringTools;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class DocumentTypeInstaller
extends ExtensionPointHandlerAdapter {
    public static final String XE_ASSOCIATE = "associate";
    public static final String XE_DOCUMENTTYPE = "documenttype";
    private static final Logger Log = LoggerFactory.getLogger(DocumentTypeInstaller.class);

    protected Object basicInstallInsert(IExtension extension, IElement element) {
        if (XE_DOCUMENTTYPE.equals(element.getName())) {
            DocumentTypeProxy object = new DocumentTypeProxy();
            object.setContext(extension.getProvider());
            object.configure(element);
            DocumentOutlet.get().registerDocumentType(object.getId(), object);
            Iterator it = element.elementIterator("alias");
            while (it.hasNext()) {
                IElement aliasElement = (IElement)it.next();
                String aliasId = aliasElement.attributeValue("id", null);
                DocumentOutlet.get().registerDocumentType(aliasId, object);
            }
        } else if (XE_ASSOCIATE.equals(element.getName())) {
            String defaultMimeType;
            String defaultExtension;
            String attrMimeTypes;
            String id = element.attributeValue("id", null);
            IDocumentType<?, ?> type = DocumentOutlet.get().lookupDocumentType(id);
            if (type == null) {
                String msg = "unknown document type '" + id + "'";
                this.log(Log, Level.ERROR, extension, element, msg, null);
                return null;
            }
            String attrExtensions = element.attributeValue("extensions", null);
            if (!StringTools.isEmpty((String)attrExtensions)) {
                String[] extensions = attrExtensions.split(";");
                for (int i = 0; i < extensions.length; ++i) {
                    DocumentOutlet.get().registerExtension(extensions[i], type);
                }
            }
            if (!StringTools.isEmpty((String)(attrMimeTypes = element.attributeValue("mimetypes", null)))) {
                String[] mimeTypes = attrMimeTypes.split(";");
                for (int i = 0; i < mimeTypes.length; ++i) {
                    DocumentOutlet.get().registerMimeType(mimeTypes[i], type);
                }
            }
            if (!StringTools.isEmpty((String)(defaultExtension = element.attributeValue("defaultextension", null)))) {
                type.setDefaultExtension(defaultExtension);
            }
            if (!StringTools.isEmpty((String)(defaultMimeType = element.attributeValue("defaultmimetype", null)))) {
                type.setDefaultMimeType(defaultMimeType);
            }
        } else {
            return super.basicInstallInsert(extension, element);
        }
        return null;
    }

    protected void basicUninstall() {
        super.basicUninstall();
        DocumentOutlet.get().clear();
    }
}

