/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.common;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ScalarHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;

public class Version
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public static Version create(int version) {
        Version result = (Version)FACTORY.createNew();
        result.setIntValue(version);
        return result;
    }

    public Version copy() throws IOException {
        return (Version)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public int getIntValue() {
        return this.getValueHolder().toDERInteger().getValue().intValue();
    }

    public void setIntValue(int version) {
        this.getValueHolder().setValue((ASN1Primitive)new ASN1Integer((long)version));
    }

    public static class Factory
    extends ASN1Based.Factory<Version> {
        @Override
        protected ASN1ValueHolder basicCreateValueHolder() {
            return new ASN1ScalarHolder();
        }
    }
}

