/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.cms.attr.ESSCertID;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.model.ASN1ValueHolder;

public class ESSCertIDv2
extends ESSCertID {
    public static final String OID_SHA256 = "2.16.840.1.101.3.4.2.1";
    public static final Factory FACTORY = new Factory();

    @Override
    protected boolean containsHashAlgorithm() {
        ASN1ValueHolder o = this.getValueHolder().getChild(0);
        return o != null && o.isSequence();
    }

    @Override
    protected String defaultHashAlgorithmOID() {
        return OID_SHA256;
    }

    public void setHashAlgorithmOID(String oid) {
        AlgorithmIdentifier algId = AlgorithmIdentifier.create(oid);
        if (this.containsHashAlgorithm()) {
            this.getValueHolder().setChild(this.indexHashAlgorithm(), algId);
        } else {
            this.getValueHolder().insertChild(this.indexHashAlgorithm(), algId);
        }
    }

    public static class Factory
    extends ESSCertID.Factory<ESSCertIDv2> {
    }
}

