/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.model.ASN1Tools;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeTimestamp
extends Attribute {
    private static final Logger Log = LoggerFactory.getLogger(AttributeTimestamp.class);
    public static final String ID = "1.2.840.113549.1.9.16.2.14";
    public static final Factory FACTORY = new Factory();

    public void addTimestamp(CMS timestamp) {
        this.addAttrValue(timestamp);
    }

    public CMS[] getTimestamps() {
        if (this.getAttrValues().size() == 0) {
            return null;
        }
        CMS[] result = new CMS[this.getAttrValues().size()];
        for (int i = 0; i < this.getAttrValues().size(); ++i) {
            ASN1Primitive value = this.getAttrValue(i).toASN1Primitive();
            if (value instanceof ASN1OctetString) {
                byte[] responseData = ((ASN1OctetString)value).getOctets();
                try {
                    ASN1Sequence seq = (ASN1Sequence)ASN1Tools.create(responseData);
                    if (seq.size() > 1) {
                        value = seq.getObjectAt(1).toASN1Primitive();
                    }
                }
                catch (Exception e) {
                    Log.warn(e.getMessage(), (Throwable)e);
                }
            }
            result[i] = (CMS)CMS.FACTORY.create((ASN1Encodable)value);
        }
        return result;
    }

    @Override
    protected void initializeAfterCreateNew() {
        super.initializeAfterCreateNew();
        this.setAttrType(ID);
    }

    public static class Factory
    extends Attribute.Factory<AttributeTimestamp> {
        @Override
        public String getAttributeType() {
            return AttributeTimestamp.ID;
        }
    }
}

