/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.IssuerAndSerialNumber;
import de.intarsys.asn1.common.SubjectKeyIdentifier;
import de.intarsys.asn1.model.ASN1Choice;
import de.intarsys.asn1.model.ASN1TaggedHolder;

public class SignerIdentifier
extends ASN1Choice {
    public static final Factory FACTORY = new Factory();

    public static SignerIdentifier create(IssuerAndSerialNumber issuerAndSerialNumber) {
        SignerIdentifier result = (SignerIdentifier)FACTORY.createNew();
        result.setIssuerAndSerialNumber(issuerAndSerialNumber);
        return result;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        if (this.isIssuerAndSerialNumber()) {
            return (IssuerAndSerialNumber)IssuerAndSerialNumber.FACTORY.create(this.getValueHolder());
        }
        return null;
    }

    public SubjectKeyIdentifier getSubjectKeyIdentifier() {
        if (this.isSubjectKeyIdentifier()) {
            return (SubjectKeyIdentifier)SubjectKeyIdentifier.FACTORY.create(this.getValueHolder().getChild());
        }
        return null;
    }

    public boolean isIssuerAndSerialNumber() {
        return !this.getValueHolder().isTagged();
    }

    public boolean isSubjectKeyIdentifier() {
        return this.getValueHolder().isTagged();
    }

    public void setIssuerAndSerialNumber(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.setValueHolder(issuerAndSerialNumber.getValueHolder());
    }

    public void setSubjectKeyIdentifier(SubjectKeyIdentifier subjectKeyId) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 0, subjectKeyId);
        this.setValueHolder(tagged);
    }

    public static class Factory
    extends ASN1Choice.Factory<SignerIdentifier> {
    }
}

