/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1ScalarHolder;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;

public class EncryptedContent
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public static EncryptedContent create(byte[] content) {
        EncryptedContent result = (EncryptedContent)FACTORY.createNew();
        result.setBytes(content);
        return result;
    }

    public EncryptedContent copy() throws IOException {
        return (EncryptedContent)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public byte[] getBytes() {
        return this.getValueHolder().toDEROctetString().getOctets();
    }

    public void setBytes(byte[] content) {
        this.getValueHolder().setValue((ASN1Primitive)new DEROctetString(content));
    }

    public static class Factory
    extends ASN1Based.Factory<EncryptedContent> {
        @Override
        protected EncryptedContent basicCreate(ASN1Encodable asn1) throws ObjectCreationException {
            if (ASN1Tools.isASN1Sequence(asn1)) {
                ASN1Sequence asn1Sequence = (ASN1Sequence)asn1.toASN1Primitive();
                int size = asn1Sequence.size();
                ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
                for (int i = 0; i < size; ++i) {
                    ASN1OctetString octetString = (ASN1OctetString)asn1Sequence.getObjectAt(i);
                    byte[] octetBytes = octetString.getOctets();
                    bos.write(octetBytes, 0, octetBytes.length);
                }
                return EncryptedContent.create(bos.toByteArray());
            }
            return (EncryptedContent)super.basicCreate(asn1);
        }

        @Override
        protected ASN1ValueHolder basicCreateValueHolder() {
            return new ASN1ScalarHolder();
        }
    }
}

