/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.standard;

import de.intarsys.tools.crypto.api.IByteStreamProvider;
import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.crypto.standard.AbstractFilterCipherFactory;
import de.intarsys.tools.crypto.standard.SecretKeyParameter;
import de.intarsys.tools.format.Format;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

public class StaticKeyCipherFactory
extends AbstractFilterCipherFactory {
    private IByteStreamProvider keyProvider;

    @Override
    protected ICipherParameter createDelegateParam(ICipherParameter param) throws GeneralSecurityException {
        if (param instanceof SecretKeyParameter) {
            SecretKeyParameter tmpParam = (SecretKeyParameter)param;
            try {
                return new SecretKeyParameter(tmpParam.getIv(), this.keyProvider.getBytes(this.getKeySize()));
            }
            catch (IOException e) {
                throw new GeneralSecurityException(Format.simple((String)"{} cannot create key", (Object[])new Object[]{this}), e);
            }
        }
        throw new InvalidKeyException(Format.simple((String)"cipher parameter {} not supported", (Object[])new Object[]{param}));
    }

    public IByteStreamProvider getKeyProvider() {
        return this.keyProvider;
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        if (this.keyProvider == null) {
            throw new IllegalArgumentException("keyProvider required");
        }
    }

    public void setKeyProvider(IByteStreamProvider keyProvider) {
        this.keyProvider = keyProvider;
    }
}

