/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.standard;

import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.crypto.api.IKeyDerivationFunction;
import de.intarsys.tools.crypto.standard.AbstractFilterCipherFactory;
import de.intarsys.tools.crypto.standard.SecretKeyParameter;
import de.intarsys.tools.format.Format;
import jakarta.annotation.PostConstruct;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

public class DerivedKeyCipherFactory
extends AbstractFilterCipherFactory {
    private IKeyDerivationFunction kdf;

    @Override
    protected ICipherParameter createDelegateParam(ICipherParameter param) throws GeneralSecurityException {
        if (param instanceof SecretKeyParameter) {
            SecretKeyParameter tmpParam = (SecretKeyParameter)param;
            byte[] derivedKey = this.getKdf().derive(tmpParam.getKey(), this.getKeySize());
            return new SecretKeyParameter(tmpParam.getIv(), derivedKey);
        }
        throw new InvalidKeyException(Format.simple((String)"cipher parameter {} not supported", (Object[])new Object[]{param}));
    }

    public IKeyDerivationFunction getKdf() {
        return this.kdf;
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        if (this.kdf == null) {
            throw new IllegalArgumentException("kdf required");
        }
    }

    public void setKdf(IKeyDerivationFunction kdf) {
        this.kdf = kdf;
    }
}

