/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto.standard;

import de.intarsys.tools.crypto.api.ICipherFactory;
import de.intarsys.tools.crypto.api.ICipherParameter;
import jakarta.annotation.PostConstruct;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

public abstract class AbstractFilterCipherFactory
implements ICipherFactory {
    private ICipherFactory cipherFactory;

    @Override
    public Cipher createDecipher(ICipherParameter param) throws GeneralSecurityException {
        ICipherParameter newParam = this.createDelegateParam(param);
        return this.cipherFactory.createDecipher(newParam);
    }

    protected abstract ICipherParameter createDelegateParam(ICipherParameter var1) throws GeneralSecurityException;

    @Override
    public Cipher createEncipher(ICipherParameter param) throws GeneralSecurityException {
        ICipherParameter newParam = this.createDelegateParam(param);
        return this.cipherFactory.createEncipher(newParam);
    }

    @Override
    public Cipher createUnwrap(ICipherParameter param) throws GeneralSecurityException {
        ICipherParameter newParam = this.createDelegateParam(param);
        return this.cipherFactory.createUnwrap(newParam);
    }

    @Override
    public Cipher createWrap(ICipherParameter param) throws GeneralSecurityException {
        ICipherParameter newParam = this.createDelegateParam(param);
        return this.cipherFactory.createWrap(newParam);
    }

    @Override
    public int getBlockSize() {
        return this.cipherFactory.getBlockSize();
    }

    public ICipherFactory getCipherFactory() {
        return this.cipherFactory;
    }

    @Override
    public String getEncryptionAlgorithmTransformation() {
        return this.cipherFactory.getEncryptionAlgorithmTransformation();
    }

    @Override
    public int getKeySize() {
        return this.getCipherFactory().getKeySize();
    }

    @PostConstruct
    public void init() {
        if (this.cipherFactory == null) {
            throw new IllegalArgumentException("cipherFactory required");
        }
    }

    public void setCipherFactory(ICipherFactory cipherFactory) {
        this.cipherFactory = cipherFactory;
    }
}

