/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.timestamp.common;

import de.intarsys.asn1.common.GeneralName;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.timestamp.ITimestampInfo;
import de.intarsys.tools.exception.ExceptionTools;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.tsp.Accuracy;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.asn1.tsp.TSTInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;

public class TimestampInfo
implements ITimestampInfo {
    private TSTInfo info;
    private Date genTime;
    private de.intarsys.asn1.common.AlgorithmIdentifier imprintAlgorithm;
    private byte[] imprintAlgorithmParams;
    private X500Principal tsa;

    public static ITimestampInfo parse(byte[] bytes) throws GeneralSecurityException, IOException {
        ASN1Primitive derTsr = ASN1Tools.create((byte[])bytes);
        TSTInfo tstInfo = TSTInfo.getInstance((Object)derTsr);
        return new TimestampInfo(tstInfo);
    }

    public TimestampInfo(TSTInfo tstInfo) throws GeneralSecurityException {
        this.info = tstInfo;
        try {
            AlgorithmIdentifier bcAlg;
            MessageImprint imprint;
            ASN1GeneralizedTime derTime = this.info.getGenTime();
            if (derTime != null) {
                this.genTime = derTime.getDate();
            }
            if ((imprint = this.info.getMessageImprint()) != null && (bcAlg = imprint.getHashAlgorithm()) != null) {
                byte[] alg = imprint.getHashAlgorithm().getEncoded("DER");
                this.imprintAlgorithm = (de.intarsys.asn1.common.AlgorithmIdentifier)ASN1BasedTools.create((ASN1Based.Factory)de.intarsys.asn1.common.AlgorithmIdentifier.FACTORY, (byte[])alg);
                if (this.imprintAlgorithm != null) {
                    this.imprintAlgorithmParams = this.imprintAlgorithm.getParametersEncoded();
                }
            }
            if (this.info.getTsa() != null) {
                GeneralName gName = (GeneralName)ASN1BasedTools.create((ASN1Based.Factory)GeneralName.FACTORY, (byte[])this.info.getTsa().getEncoded());
                this.tsa = CertificateTools.parsePrincipal(gName);
            }
        }
        catch (ParseException e) {
            throw new GeneralSecurityException("invalid data structure in timestamp!");
        }
        catch (IOException e) {
            throw new CertificateException("invalid data structure in timestamp!", e);
        }
    }

    @Override
    public BigInteger getAccuracyMicros() {
        Accuracy acc = this.info.getAccuracy();
        if (acc == null) {
            return null;
        }
        ASN1Integer value = acc.getMicros();
        if (value == null) {
            return null;
        }
        return value.getPositiveValue();
    }

    @Override
    public BigInteger getAccuracyMillis() {
        Accuracy acc = this.info.getAccuracy();
        if (acc == null) {
            return null;
        }
        ASN1Integer value = acc.getMillis();
        if (value == null) {
            return null;
        }
        return value.getPositiveValue();
    }

    @Override
    public BigInteger getAccuracySeconds() {
        Accuracy acc = this.info.getAccuracy();
        if (acc == null) {
            return null;
        }
        ASN1Integer value = acc.getSeconds();
        if (value == null) {
            return null;
        }
        return value.getPositiveValue();
    }

    public Set getCriticalExtensionOIDs() {
        HashSet<String> result = new HashSet<String>();
        Extensions extensions = this.info.getExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e.nextElement();
                Extension ext = extensions.getExtension(oid);
                if (ext == null || !ext.isCritical()) continue;
                result.add(oid.getId());
            }
        }
        return result;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.info.getEncoded("DER");
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        Extensions extensions = this.info.getExtensions();
        if (extensions == null) {
            return null;
        }
        Extension ext = extensions.getExtension(new ASN1ObjectIdentifier(oid));
        if (ext == null) {
            return null;
        }
        try {
            return ext.getExtnValue().getEncoded("DER");
        }
        catch (IOException e) {
            throw ExceptionTools.wrap((Throwable)e);
        }
    }

    @Override
    public Date getGenTime() {
        return this.genTime;
    }

    public TSTInfo getInfo() {
        return this.info;
    }

    @Override
    public String getMessageImprintAlgorithmName() {
        String algName = SignatureAlgorithm.getHashAlgorithmName(this.getMessageImprintAlgorithmOID());
        if (algName != null) {
            return algName;
        }
        return this.getMessageImprintAlgorithmOID();
    }

    @Override
    public String getMessageImprintAlgorithmOID() {
        if (this.imprintAlgorithm == null) {
            return null;
        }
        return this.imprintAlgorithm.getAlgorithm();
    }

    @Override
    public byte[] getMessageImprintAlgorithmParams() {
        return this.imprintAlgorithmParams;
    }

    @Override
    public byte[] getMessageImprintHash() {
        MessageImprint imprint = this.info.getMessageImprint();
        if (imprint == null) {
            return null;
        }
        return imprint.getHashedMessage();
    }

    @Override
    public BigInteger getNonce() {
        ASN1Integer value = this.info.getNonce();
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet<String> result = new HashSet<String>();
        Extensions extensions = this.info.getExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)e.nextElement();
                Extension ext = extensions.getExtension(oid);
                if (ext == null || ext.isCritical()) continue;
                result.add(oid.getId());
            }
        }
        return result;
    }

    @Override
    public Boolean getOrdering() {
        ASN1Boolean value = this.info.getOrdering();
        if (value == null) {
            return null;
        }
        return value.isTrue();
    }

    @Override
    public String getPolicy() {
        ASN1ObjectIdentifier value = this.info.getPolicy();
        if (value == null) {
            return null;
        }
        return value.getId();
    }

    @Override
    public BigInteger getSerialNumber() {
        ASN1Integer value = this.info.getSerialNumber();
        if (value == null) {
            return null;
        }
        return value.getPositiveValue();
    }

    @Override
    public X500Principal getTsa() {
        return this.tsa;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set extensions = this.getCriticalExtensionOIDs();
        return extensions != null && !extensions.isEmpty();
    }
}

