/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation.commonpki;

import de.intarsys.security.standard.validation.commonpki.ISignatureAlgorithmInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class RSASignatureAlgorithmInfo
implements ISignatureAlgorithmInfo {
    private PublicKey publicKey;
    private RSAPublicKeyStructure rsaKey;

    public RSASignatureAlgorithmInfo(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public String getAlgorithmName() {
        return "RSA";
    }

    public int getKeySize() throws IOException {
        return this.getRSAKey().getModulus().bitLength();
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    protected RSAPublicKeyStructure getRSAKey() throws IOException {
        if (this.rsaKey == null) {
            ASN1InputStream aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.getPublicKey().getEncoded()));
            SubjectPublicKeyInfo keyInfo = SubjectPublicKeyInfo.getInstance((Object)aIn.readObject());
            aIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(keyInfo.getPublicKey().getEncoded()));
            this.rsaKey = RSAPublicKeyStructure.getInstance((Object)aIn.readObject());
        }
        return this.rsaKey;
    }
}

