/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.standard.validation;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPResponse;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.Base64;
import java.util.List;
import java.util.stream.Stream;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public class ArgsValidationData
implements IExtendedValidationData {
    private IArgs args;

    public ArgsValidationData(IArgs args) {
        this.args = args;
    }

    @Override
    public Stream<IX509PublicKeyCertificate> getCertificates() {
        List certificates = ArgTools.getList((IArgs)this.args, (String)"certificates", null);
        if (certificates == null) {
            return Stream.empty();
        }
        return certificates.stream().map(Base64.getDecoder()::decode).map(value -> {
            try {
                return X509CertificateFactory.get().createPublicKeyCertificate((byte[])value);
            }
            catch (CertificateException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public Stream<IX509CRL> getCRLs() {
        List crls = ArgTools.getList((IArgs)this.args, (String)"crls", null);
        if (crls == null) {
            return Stream.empty();
        }
        return crls.stream().map(s -> Base64.getDecoder().decode((String)s)).map(value -> {
            IX509CRL iX509CRL;
            ByteArrayInputStream is = new ByteArrayInputStream((byte[])value);
            try {
                iX509CRL = X509CertificateFactory.get().createCRL(is);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | CRLException e) {
                    throw new RuntimeException(e);
                }
            }
            ((InputStream)is).close();
            return iX509CRL;
        });
    }

    @Override
    public Stream<IOCSPResponse> getOCSPResponses() {
        List ocspResponses = ArgTools.getList((IArgs)this.args, (String)"ocspResponses", null);
        if (ocspResponses == null) {
            return Stream.empty();
        }
        return ocspResponses.stream().map(s -> Base64.getDecoder().decode((String)s)).map(value -> new OCSPResponse(new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)value))));
    }
}

