/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.signature.policy;

import de.intarsys.security.signature.policy.CommitmentTypeIndication;
import de.intarsys.security.signature.policy.IAutomationPolicy;
import de.intarsys.security.signature.policy.ICommitmentTypeIndication;
import de.intarsys.security.signature.policy.IPolicy;
import de.intarsys.security.signature.policy.IPolicyId;
import de.intarsys.security.signature.policy.IPolicyReference;
import de.intarsys.security.signature.policy.IQualifier;
import de.intarsys.security.signature.policy.ImpliedPolicy;
import de.intarsys.security.signature.policy.PolicyId;
import de.intarsys.security.signature.policy.UnprocessablePolicy;
import de.intarsys.security.signature.policy.asn1.ASN1SignaturePolicy;
import de.intarsys.security.signature.policy.common.CommitmentType;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.tag.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class PolicyTools {
    public static final String ARG_IMPLIED = "implied";
    public static final String ARG_OID = "oid";
    public static final String ARG_NAME = "name";
    public static final String ARG_HASH = "hash";
    public static final String ARG_LOCATOR = "locator";
    public static final String ARG_QUALIFIERS = "qualifiers";
    private static final Attribute ATTR_POLICY = new Attribute("policy");

    protected static ICommitmentTypeIndication createCommitmentTypeIndication(IArgs args) throws ObjectCreationException {
        String oid = ArgTools.getString((IArgs)args, (String)ARG_OID, null);
        if (oid == null) {
            CommitmentType standardType = (CommitmentType)ArgTools.getEnumItemStrict((IArgs)args, CommitmentType.META, (String)ARG_NAME, (EnumItem)null);
            if (standardType == null) {
                throw new IllegalArgumentException("Unknown commitment type.");
            }
            oid = standardType.getOid();
        }
        CommitmentTypeIndication commitmentTypeIndication = new CommitmentTypeIndication(oid);
        IArgs qualifiers = ArgTools.getArgs((IArgs)args, (String)ARG_QUALIFIERS, (IArgs)Args.create());
        Iterator i = qualifiers.bindings();
        while (i.hasNext()) {
            IArgs.IBinding binding = (IArgs.IBinding)i.next();
            IQualifier qualifier = PolicyTools.createQualifier(binding.getValue());
            commitmentTypeIndication.addQualifier(qualifier);
        }
        return commitmentTypeIndication;
    }

    public static ICommitmentTypeIndication createCommitmentTypeIndication(Object object) throws ObjectCreationException {
        if (object instanceof ICommitmentTypeIndication) {
            return (ICommitmentTypeIndication)object;
        }
        if (object instanceof IArgs) {
            return PolicyTools.createCommitmentTypeIndication((IArgs)object);
        }
        try {
            return (ICommitmentTypeIndication)ConverterRegistry.get().convert(object, ICommitmentTypeIndication.class);
        }
        catch (ConversionException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static IPolicyReference createPolicyReference(IArgs args) throws ObjectCreationException {
        IDigest digest;
        if (ArgTools.getBoolStrict((IArgs)args, (String)ARG_IMPLIED, (boolean)false)) {
            return ImpliedPolicy.INSTANCE;
        }
        String oid = ArgTools.getString((IArgs)args, (String)ARG_OID, null);
        try {
            digest = ArgTools.getDigest((IArgs)args, (String)ARG_HASH);
        }
        catch (IOException e) {
            throw new ObjectCreationException((Throwable)e);
        }
        ILocator locator = ArgTools.getLocator((IArgs)args, (String)ARG_LOCATOR, null, (ILocatorFactory)LocatorFactory.get());
        IPolicy policy = null;
        PolicyId policyId = null;
        if (oid == null) {
            if (locator == null) {
                throw new IllegalArgumentException("Must specify either policy oid or locator.");
            }
            try {
                policy = PolicyTools.parsePolicy(locator);
            }
            catch (IOException e) {
                throw new ObjectCreationException((Throwable)e);
            }
            if (!(policy instanceof IAutomationPolicy)) throw new IllegalArgumentException("Cannot read oid from unprocessable policy " + locator.getPath());
            oid = ((IAutomationPolicy)policy).getOID();
            policyId = new PolicyId(oid);
        } else {
            policyId = new PolicyId(oid);
            if (locator == null) {
                policy = PolicyTools.lookupPolicy(policyId);
            } else {
                try {
                    policy = PolicyTools.parsePolicy(locator);
                }
                catch (IOException e) {
                    throw new ObjectCreationException((Throwable)e);
                }
            }
        }
        policyId.setDigest(digest);
        if (policy != null) {
            policyId.setAttribute(ATTR_POLICY, policy);
        }
        IArgs qualifiers = ArgTools.getArgs((IArgs)args, (String)ARG_QUALIFIERS, (IArgs)Args.create());
        Iterator i = qualifiers.bindings();
        while (i.hasNext()) {
            IArgs.IBinding binding = (IArgs.IBinding)i.next();
            IQualifier qualifier = PolicyTools.createQualifier(binding.getValue());
            policyId.addQualifier(qualifier);
        }
        return policyId;
    }

    public static IPolicyReference createPolicyReference(Object object) throws ObjectCreationException {
        if (object instanceof IPolicyReference) {
            return (IPolicyReference)object;
        }
        if (object instanceof IArgs) {
            return PolicyTools.createPolicyReference((IArgs)object);
        }
        try {
            return (IPolicyReference)ConverterRegistry.get().convert(object, IPolicyReference.class);
        }
        catch (ConversionException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    protected static IQualifier createQualifier(IArgs args) throws ObjectCreationException {
        ArrayList<Tag> factoryTags = new ArrayList<Tag>();
        String oid = ArgTools.getString((IArgs)args, (String)ARG_OID, null);
        if (oid == null) {
            String name = ArgTools.getString((IArgs)args, (String)ARG_NAME, null);
            if (name == null) {
                throw new IllegalArgumentException("Qualifier OID or name must be given.");
            }
            factoryTags.add(new Tag(ARG_NAME, name));
        } else {
            factoryTags.add(new Tag(ARG_OID, oid));
        }
        IFactory qualifierFactory = FactoryTools.lookupFactoryFor(IQualifier.class, factoryTags);
        if (qualifierFactory == null) {
            throw new IllegalArgumentException("Unknown qualifier type.");
        }
        return (IQualifier)qualifierFactory.createInstance(args);
    }

    public static IQualifier createQualifier(Object object) throws ObjectCreationException {
        if (object instanceof IQualifier) {
            return (IQualifier)object;
        }
        if (object instanceof IArgs) {
            return PolicyTools.createQualifier((IArgs)object);
        }
        try {
            return (IQualifier)ConverterRegistry.get().convert(object, IQualifier.class);
        }
        catch (ConversionException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    public static IPolicy lookupPolicy(IPolicyId policyId) {
        IPolicy policy = (IPolicy)policyId.getAttribute(ATTR_POLICY);
        if (policy != null) {
            return policy;
        }
        if (policy != null) {
            policyId.setAttribute(ATTR_POLICY, policy);
        }
        return policy;
    }

    public static IPolicy parsePolicy(ILocator locator) throws IOException {
        if ("der".equals(LocatorTools.getExtension((ILocator)locator))) {
            return ASN1SignaturePolicy.create(locator);
        }
        return new UnprocessablePolicy(locator);
    }

    private PolicyTools() {
    }
}

