/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class ExtendedKeyUsageHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("ExtendedKeyUsageHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.37";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Primitive obj = CertificateTools.getExtensionValue(object, this.getOID());
        ExtendedKeyUsage keyUsage = ExtendedKeyUsage.getInstance((Object)obj);
        if (keyUsage == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (keyUsage.hasKeyPurposeId(KeyPurposeId.anyExtendedKeyUsage)) {
            sb.append("Any extended key usage").append(StringTools.LS);
        }
        if (keyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_clientAuth)) {
            sb.append("Client authentication").append(StringTools.LS);
        }
        if (keyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_codeSigning)) {
            sb.append("Code signing").append(StringTools.LS);
        }
        if (keyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_emailProtection)) {
            sb.append("Email protection").append(StringTools.LS);
        }
        if (keyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_ipsecEndSystem)) {
            sb.append("ipsec end system").append(StringTools.LS);
        }
        if (keyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_ipsecTunnel)) {
            sb.append("ipsec tunnel").append(StringTools.LS);
        }
        if (keyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_ipsecUser)) {
            sb.append("ipsec user").append(StringTools.LS);
        }
        if (keyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_OCSPSigning)) {
            sb.append("OCSP signing").append(StringTools.LS);
        }
        if (keyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_serverAuth)) {
            sb.append("Server authentication").append(StringTools.LS);
        }
        if (keyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_smartcardlogon)) {
            sb.append("Smartcard logon").append(StringTools.LS);
        }
        if (keyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_timeStamping)) {
            sb.append("Timestamp signing").append(StringTools.LS);
        }
        return sb.toString();
    }
}

