/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.extension.common;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.extension.CommonX509ExtensionHandler;
import de.intarsys.security.extension.common.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.X509Extension;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.BasicConstraints;

public class BasicConstraintsHandler
extends CommonX509ExtensionHandler {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public String getLabel() {
        return Msg.getString("BasicConstraintsHandler.Label", new Object[0]);
    }

    @Override
    public String getOID() {
        return "2.5.29.19";
    }

    @Override
    public String getStringValue(X509Extension object) throws IOException {
        ASN1Primitive value = CertificateTools.getExtensionValue(object, this.getOID());
        BasicConstraints bc = BasicConstraints.getInstance((Object)value);
        if (bc == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CA: ").append(bc.isCA()).append(StringTools.LS);
        if (bc.getPathLenConstraint() != null) {
            sb.append("Path length: ").append(bc.getPathLenConstraint().toString()).append(StringTools.LS);
        }
        return sb.toString();
    }
}

