/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.encoding;

import de.intarsys.security.encoding.IEncoding;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractEncoding
implements IEncoding {
    private int intendedLengthBytes;
    private int intendedLengthBits;
    private boolean derEncoded = true;

    protected byte[] basicDecode(byte[] bytes) throws IOException {
        throw new IOException("not implemented");
    }

    protected byte[] basicEncode(byte[] bytes) throws IOException {
        throw new IOException("not implemented");
    }

    protected boolean basicMatch(byte[] bytes, byte[] encoded) throws IOException {
        byte[] unpadded = this.decode(encoded);
        return Arrays.equals(bytes, unpadded);
    }

    @Override
    public final byte[] decode(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerException("bytes can't be null");
        }
        return this.basicDecode(bytes);
    }

    @Override
    public final byte[] encode(byte[] bytes) throws IOException {
        if (bytes == null) {
            throw new NullPointerException("bytes can't be null");
        }
        return this.basicEncode(bytes);
    }

    public int getIntendedLengthBits() {
        return this.intendedLengthBits;
    }

    public int getIntendedLengthBytes() {
        return this.intendedLengthBytes;
    }

    public boolean isDerEncoded() {
        return this.derEncoded;
    }

    @Override
    public final boolean match(byte[] bytes, byte[] encoded) throws IOException {
        if (bytes == null) {
            throw new NullPointerException("bytes can't be null");
        }
        if (encoded == null) {
            throw new NullPointerException("encoded can't be null");
        }
        return this.basicMatch(bytes, encoded);
    }

    public void setDerEncoded(boolean derEncoded) {
        this.derEncoded = derEncoded;
    }

    public void setIntendedLengthBits(int value) {
        this.intendedLengthBits = value;
        this.intendedLengthBytes = (value + 7) / 8;
    }

    public void setIntendedLengthBytes(int value) {
        this.intendedLengthBits = value * 8;
        this.intendedLengthBytes = value;
    }
}

