/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.crl.common;

import de.intarsys.security.crl.ICRLProvider;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.IX509CRLSelector;
import de.intarsys.security.crl.common.CRLCache;
import de.intarsys.security.crl.common.CompositeCRLProvider;
import de.intarsys.security.crl.common.ICRLCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalCRLProvider
extends CompositeCRLProvider {
    private static final Logger Log = LoggerFactory.getLogger(LocalCRLProvider.class);
    private final long STORAGE_TIME_WITHOUT_NEXT_UPDATE = 43200000L;
    private ICRLCache cachedCRLs;
    private final Map<IX509CRL, Date> nextUpdates = new HashMap<IX509CRL, Date>();

    protected void basicAddCRLs(IX509CRLSelector selector, String url, Collection<IX509CRL> crls) {
        for (IX509CRL crl : crls) {
            try {
                this.getCachedCRLs().addCRL(crl);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (crl.getNextUpdate() != null) continue;
            this.nextUpdates.put(crl, new Date(System.currentTimeMillis() + 43200000L));
        }
    }

    @Override
    protected Stream<IX509CRL> basicLookupCRLs(IX509CRLSelector selector, String url) throws IOException {
        Date referenceDate = selector.getDateAndTime();
        List<IX509CRL> result = this.getCachedCRLs().lookupCRLs(selector, url).collect(Collectors.toList());
        this.removeInvalid(result, referenceDate);
        return result.stream();
    }

    public ICRLCache getCachedCRLs() {
        if (this.cachedCRLs == null) {
            this.cachedCRLs = new CRLCache();
        }
        return this.cachedCRLs;
    }

    private Date getNextUpdate(IX509CRL crl) {
        Date nextUpdate = crl.getNextUpdate();
        if (nextUpdate != null) {
            return nextUpdate;
        }
        return this.nextUpdates.get(crl);
    }

    @Override
    public final Stream<IX509CRL> lookupCRLs(IX509CRLSelector selector, String url) throws IOException {
        Stream<IX509CRL> result = this.basicLookupCRLs(selector, url);
        List list = result.collect(Collectors.toList());
        if (!list.isEmpty()) {
            return list.stream();
        }
        list = new ArrayList();
        for (ICRLProvider provider : this.getDelegateProviders()) {
            try {
                List<IX509CRL> crls = provider.lookupCRLs(selector, url).collect(Collectors.toList());
                this.basicAddCRLs(selector, url, crls);
                list.addAll(crls);
            }
            catch (Exception e) {
                Log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return list.stream();
    }

    protected void removeInvalid(Collection<IX509CRL> crls, Date referenceDate) {
        if (referenceDate == null) {
            return;
        }
        Iterator<IX509CRL> i = crls.iterator();
        while (i.hasNext()) {
            IX509CRL crl = i.next();
            Date nextUpdate = this.getNextUpdate(crl);
            if (nextUpdate != null && !referenceDate.after(nextUpdate)) continue;
            i.remove();
        }
    }

    public void setCachedCRLs(ICRLCache cachedCRLs) {
        this.cachedCRLs = cachedCRLs;
    }
}

