/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.creation;

import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;

public class ECKeyPairFactory
implements IFactory<KeyPair> {
    public static final String ID = ECKeyPairFactory.class.getName();
    public static final String ARG_CURVENAME = "curveName";

    public KeyPair createInstance(IArgs args) throws ObjectCreationException {
        try {
            KeyPairGenerator kpGenerator = KeyPairGenerator.getInstance("EC", "BC");
            ECParameterSpec ecSpec = this.createParameterSpec(args);
            kpGenerator.initialize((AlgorithmParameterSpec)ecSpec, CryptoTools.createSecureRandom());
            return kpGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    protected ECParameterSpec createParameterSpec(IArgs args) {
        String curveName = ArgTools.getString((IArgs)args, (String)ARG_CURVENAME, (String)"prime192v1");
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
        return ecSpec;
    }

    public String getId() {
        return ID;
    }

    public Class<? extends KeyPair> getResultType() {
        return KeyPair.class;
    }
}

