/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.common;

import de.intarsys.security.algorithm.common.AlgorithmTools;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.validation.CommonValidator;
import de.intarsys.tools.validation.IValidationResult;
import de.intarsys.tools.validation.ValidationResult;

public class CertificateSignatureAlgorithmValidator
extends CommonValidator<IX509PublicKeyCertificate> {
    private CommonPKIProfile commonPkiProfile = CommonPKIProfile.QES_SigG;

    protected void basicValidate(ValidationResult result, IX509PublicKeyCertificate target) {
    }

    public void configure(IElement elCertSigAlg) {
        CommonPKIProfile.META.getItemOrDefault(elCertSigAlg.attributeValue("pkiProfile", null));
    }

    public CommonPKIProfile getCommonPkiProfile() {
        return this.commonPkiProfile;
    }

    public CommonPKIProfile getCommonPKIProfile() {
        return this.commonPkiProfile;
    }

    public void setCommonPkiProfile(CommonPKIProfile commonPkiProfile) {
        this.commonPkiProfile = commonPkiProfile;
    }

    public IValidationResult validate(IX509PublicKeyCertificate target) {
        if (target != null) {
            CommonPKIProfile profile = this.getCommonPKIProfile();
            return AlgorithmTools.checkForWeakSignatureAlgorithm(profile, target);
        }
        return super.validate((Object)target);
    }
}

