/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.attribute;

import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.common.GeneralName;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.attr.IssuerSerial;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.attribute.AbstractMultivalueAttribute;
import de.intarsys.security.certificate.attribute.ProcurationSyntax;
import org.bouncycastle.asn1.ASN1Encodable;

public class ProcurationAttribute
extends AbstractMultivalueAttribute {
    public static final String OID = "1.3.36.8.3.2";

    public ProcurationAttribute(Attribute attribute) {
        super(attribute);
    }

    @Override
    public String getLabel() {
        return Msg.getString("ProcurationAttribute.Label", new Object[0]);
    }

    public ProcurationSyntax getProcurationSyntax(int index) {
        ASN1ValueHolder value = this.getAttribute().getAttrValue(index);
        return (ProcurationSyntax)ProcurationSyntax.FACTORY.create((ASN1Encodable)value);
    }

    @Override
    public String getStringValue(int index) {
        String country;
        ProcurationSyntax proc = this.getProcurationSyntax(index);
        StringBuilder sb = new StringBuilder();
        String type = proc.getTypeOfSubstitution();
        if (type != null) {
            sb.append(Msg.getString("ProcurationAttribute.LabelType", new Object[0]) + ": " + type).append("\n");
        }
        if ((country = proc.getCountry()) != null) {
            sb.append(Msg.getString("ProcurationAttribute.LabelCountry", new Object[0]) + ": " + country).append("\n");
        }
        String signingFor = null;
        if (proc.isSigningForIssuerSerial()) {
            IssuerSerial serial = proc.getSigningForIssuerSerial();
            signingFor = serial.getSerial().getValue().toString();
        } else {
            GeneralName name = proc.getSigningForGeneralName();
            signingFor = CertificateTools.toString(name);
        }
        if (signingFor != null) {
            sb.append(Msg.getString("ProcurationAttribute.LabelSigningFor", new Object[0]) + ": " + signingFor).append("\n");
        }
        return sb.toString();
    }
}

