/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.qes;

import de.intarsys.security.app.validation.commonpki.qes.IExtensionProfile;
import de.intarsys.security.app.validation.commonpki.qes.IExtensionProfileSet;
import de.intarsys.security.app.validation.commonpki.qes.PACKAGE;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.VSDefault;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.tools.message.IMessageBundle;
import java.security.cert.X509Extension;
import java.util.Set;

public class ExtensionProfileValidator {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected void validate(X509Extension extensionSupport, IExtensionProfile extensionProfile, CommonValidationState state) {
        String oid = extensionProfile.getOid();
        String name = extensionProfile.getName();
        boolean exists = false;
        boolean critical = false;
        Set<String> criticalExtensionOIDs = extensionSupport.getCriticalExtensionOIDs();
        Set<String> nonCriticalExtensionOIDs = extensionSupport.getNonCriticalExtensionOIDs();
        if (criticalExtensionOIDs != null && criticalExtensionOIDs.contains(oid)) {
            exists = true;
            critical = true;
        } else if (nonCriticalExtensionOIDs != null && nonCriticalExtensionOIDs.contains(oid)) {
            exists = true;
        }
        if (exists) {
            switch (extensionProfile.getSupportGen()) {
                case MUST_NOT: {
                    state.invalidate(Msg.getString("ExtensionProfileValidator.ExtGenMustNot", new Object[]{name, oid}));
                    break;
                }
                case SHOULD_NOT: {
                    state.addMessage(ValidationMessage.createWarning(Msg.getString("ExtensionProfileValidator.ExtGenShouldNot", new Object[]{name, oid})));
                    break;
                }
            }
            if (critical) {
                switch (extensionProfile.getCritical()) {
                    case MUST_NOT: {
                        state.invalidate(Msg.getString("ExtensionProfileValidator.ExtCriticalMustNot", new Object[]{name, oid}));
                        break;
                    }
                    case SHOULD_NOT: {
                        state.addMessage(ValidationMessage.createWarning(Msg.getString("ExtensionProfileValidator.ExtCriticalShouldNot", new Object[]{name, oid})));
                        break;
                    }
                }
            } else {
                switch (extensionProfile.getCritical()) {
                    case MUST: {
                        state.invalidate(Msg.getString("ExtensionProfileValidator.ExtCriticalMust", new Object[]{name, oid}));
                        break;
                    }
                    case SHOULD: {
                        state.addMessage(ValidationMessage.createWarning(Msg.getString("ExtensionProfileValidator.ExtCriticalShould", new Object[]{name, oid})));
                        break;
                    }
                }
            }
        } else {
            switch (extensionProfile.getSupportGen()) {
                case MUST: {
                    state.invalidate(Msg.getString("ExtensionProfileValidator.ExtGenMust", new Object[]{name, oid}));
                    break;
                }
                case SHOULD: {
                    state.addMessage(ValidationMessage.createWarning(Msg.getString("ExtensionProfileValidator.ExtGenShould", new Object[]{name, oid})));
                    break;
                }
            }
        }
    }

    public IValidationState validate(X509Extension extensionSupport, IExtensionProfileSet profileSet) {
        VSDefault state = new VSDefault();
        for (IExtensionProfile extensionProfile : profileSet.getExtensionProfiles()) {
            this.validate(extensionSupport, extensionProfile, state);
        }
        return state;
    }
}

