/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.security.app.validation.ICertificateChecker;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.commonpki.PACKAGE;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.Info;
import de.intarsys.security.standard.validation.InfoSet;
import de.intarsys.security.standard.validation.VSCertificate;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.NoticeReference;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierInfo;
import org.bouncycastle.asn1.x509.UserNotice;

public class CertificatePoliciesChecker
implements ICertificateChecker {
    private static final String CERTIFICATE_POLICIES = "2.5.29.32";
    private static final String id_qt_cps = "1.3.6.1.5.5.7.2.1";
    private static final String id_qt_unotice = "1.3.6.1.5.5.7.2.2";
    private static final IMessageBundle Msg = PACKAGE.Messages;

    @Override
    public void checkCertificate(IX509Certificate certificate, IValidationParameters params, Set<String> unresolvedCriticalExtensions, VSCertificate state) {
        if (certificate == null) {
            return;
        }
        this.collectPolicies(certificate, state);
        this.removeSupportedExtensions(unresolvedCriticalExtensions);
    }

    protected void collectPolicies(IX509Certificate certificate, VSCertificate state) {
        ASN1Sequence derExplicitPolicies = null;
        try {
            derExplicitPolicies = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, CERTIFICATE_POLICIES);
        }
        catch (IOException e) {
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, CERTIFICATE_POLICIES));
        }
        if (derExplicitPolicies == null) {
            return;
        }
        InfoSet infoSet = new InfoSet(Msg.getString("CertificatePoliciesChecker.LabelPolicies", new Object[0]));
        Enumeration e = derExplicitPolicies.getObjects();
        while (e.hasMoreElements()) {
            ASN1Encodable derPolicyInformation = (ASN1Encodable)e.nextElement();
            PolicyInformation policyInformation = PolicyInformation.getInstance((Object)derPolicyInformation);
            ASN1ObjectIdentifier policyIdentifier = policyInformation.getPolicyIdentifier();
            String infoTitle = policyIdentifier.getId();
            ASN1Sequence derPolicyQualifiers = policyInformation.getPolicyQualifiers();
            if (derPolicyQualifiers == null) {
                infoSet.addInfo(new Info(infoTitle));
                continue;
            }
            Enumeration en = derPolicyQualifiers.getObjects();
            while (en.hasMoreElements()) {
                ASN1Encodable derPolicyQualifier = (ASN1Encodable)en.nextElement();
                PolicyQualifierInfo policyQualifierInfo = PolicyQualifierInfo.getInstance((Object)derPolicyQualifier);
                String id = policyQualifierInfo.getPolicyQualifierId().getId();
                if (id_qt_cps.equals(id)) {
                    DERIA5String text = (DERIA5String)policyQualifierInfo.getQualifier();
                    infoSet.addInfo(new Info(infoTitle, text.getString()));
                    continue;
                }
                if (!id_qt_unotice.equals(id)) continue;
                UserNotice notice = UserNotice.getInstance((Object)policyQualifierInfo.getQualifier());
                if (notice.getExplicitText() != null) {
                    String text = notice.getExplicitText().getString();
                    infoSet.addInfo(new Info(infoTitle, text));
                }
                if (notice.getNoticeRef() == null) continue;
                NoticeReference reference = notice.getNoticeRef();
                String organization = reference.getOrganization() == null ? "" : reference.getOrganization().getString();
                String noticeNumber = "";
                if (reference.getNoticeNumbers() != null) {
                    StringBuilder number = new StringBuilder();
                    for (ASN1Integer integer : reference.getNoticeNumbers()) {
                        number.append(integer.getValue().intValue());
                    }
                    noticeNumber = number.toString();
                }
                StringBuilder infoText = new StringBuilder();
                infoText.append("--> ");
                infoText.append(organization);
                infoText.append(" / ");
                infoText.append(noticeNumber);
                infoSet.addInfo(new Info(infoTitle, infoText.toString()));
            }
        }
        if (infoSet.size() > 0) {
            state.addAdditionalInfoObject(infoSet);
        }
    }

    protected void removeSupportedExtensions(Set<String> unresolvedCriticalExtensions) {
        unresolvedCriticalExtensions.remove(CERTIFICATE_POLICIES);
    }
}

