/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.common;

import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.common.CommonValidationDataCollector;
import de.intarsys.security.app.validation.common.EntryStateValidationDataCollector;
import de.intarsys.security.app.validation.common.PACKAGE;
import de.intarsys.security.app.validation.common.StateCachingStrategy;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.standard.validation.commonpki.OCSPDepth;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryValidationDataCollector
extends CommonValidationDataCollector {
    private static final Logger Log = LoggerFactory.getLogger(EntryValidationDataCollector.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final ISignatureContainerEntry entry;

    public EntryValidationDataCollector(ISignatureContainerEntry entry) {
        this.entry = entry;
    }

    @Override
    public IExtendedValidationData collect() throws IOException {
        IValidationState state = this.validate();
        EntryStateValidationDataCollector delegate = new EntryStateValidationDataCollector(state);
        delegate.setValidationDataOptions(this.getValidationDataOptions());
        delegate.setCollectSignatureData(this.isCollectSignatureData());
        delegate.setCollectTimestampData(this.isCollectTimestampData());
        return delegate.collect();
    }

    public ISignatureContainerEntry getEntry() {
        return this.entry;
    }

    protected IValidationState validate() {
        Args contextArgs = Args.create();
        contextArgs.put("checkCRL", (Object)this.getValidationDataOptions().isAddRevocationInfoTypeCrl());
        contextArgs.put("checkOCSP", (Object)this.getValidationDataOptions().isAddRevocationInfoTypeOcsp());
        contextArgs.put("ocspDepth", (Object)OCSPDepth.FULL);
        contextArgs.put("stateCachingStrategy", (Object)StateCachingStrategy.noCache());
        IValidationContext context = ValidationEnvironment.get().getValidationContextFactory().createValidationContext((IArgs)contextArgs);
        ValidationParameters parameters = new ValidationParameters();
        return context.getSignatureContainerEntryValidator().validate(this.getEntry(), null, parameters);
    }
}

