/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation;

import de.intarsys.security.app.validation.ISignatureEntryValidator;
import de.intarsys.security.app.validation.SignatureEntryValidatorFactory;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.signature.EncodedSignature;
import de.intarsys.security.signature.EncodedSignatureEntry;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSSignature;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;

public abstract class X509SignatureValidator<T> {
    private static final Attribute ATTR_SIGNATURESTATE = new Attribute("signatureState");

    public static X509SignatureValidator<IX509Certificate> createCertificateInstance() {
        return new CertificateSignatureValidator();
    }

    public static X509SignatureValidator<IX509CRL> createCRLInstance() {
        return new CRLSignatureValidator();
    }

    public static X509SignatureValidator<BasicOCSPResp> createOCSPInstance() {
        return new OCSPSignatureValidator();
    }

    protected IVSSignature basicValidate(T element, IX509PublicKeyCertificate certificate) {
        String sigAlgOID = this.getSigAlgOID(element);
        if (sigAlgOID == null) {
            VSSignature state = new VSSignature(null, 3);
            state.addMessage(CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN(null, "no algorithm provided"));
            return state;
        }
        IDigest digest = null;
        try {
            byte[] signatureBytes = this.getSignature(element);
            byte[] sigAlgParams = this.getSigAlgParams(element);
            EncodedSignature signature = EncodedSignature.create(signatureBytes, sigAlgOID, sigAlgParams, certificate);
            digest = this.getDigest(element, signature.getHashAlgorithmSpec().getAlgorithm().getCanonicalName());
            EncodedSignatureEntry entry = signature.getEntry();
            ISignatureEntryValidator validator = this.createValidator(entry);
            IVSSignatureEntry entryState = (IVSSignatureEntry)validator.validate(entry, digest, new ValidationParameters());
            return entryState.getSignatureState();
        }
        catch (NoSuchAlgorithmException e) {
            VSSignature state = new VSSignature(digest, 3);
            state.addMessage(CommonValidationMessages.ERROR_ALGORITHM_UNKNOWN(e, e.getMessage()));
            return state;
        }
        catch (GeneralSecurityException e) {
            VSSignature state = new VSSignature(digest, 3);
            state.addMessage(CommonValidationMessages.ERROR_CERTIFICATE(e));
            return state;
        }
        catch (IOException e) {
            VSSignature state = new VSSignature(digest, 3);
            state.addMessage(CommonValidationMessages.ERROR_IO(e));
            return state;
        }
    }

    protected ISignatureEntryValidator createValidator(EncodedSignatureEntry entry) {
        return SignatureEntryValidatorFactory.get().createValidator(entry, (IArgs)Args.create());
    }

    protected IDigest getDigest(T element, String digestAlgName) throws NoSuchAlgorithmException, GeneralSecurityException {
        IDigester digester = DigestTools.createDigester((String)digestAlgName);
        IDigest digest = digester.digest(this.getTBS(element));
        return digest;
    }

    protected abstract String getSigAlgOID(T var1);

    protected abstract byte[] getSigAlgParams(T var1) throws IOException;

    protected abstract byte[] getSignature(T var1);

    protected abstract byte[] getTBS(T var1) throws GeneralSecurityException;

    public IVSSignature validate(T element, IX509PublicKeyCertificate certificate) {
        SoftReference<IVSSignature> stateAttr;
        IVSSignature state = null;
        if (element instanceof IAttributeSupport && (stateAttr = (SoftReference<IVSSignature>)((IAttributeSupport)element).getAttribute((Object)ATTR_SIGNATURESTATE)) != null && (state = (IVSSignature)stateAttr.get()) != null) {
            return state;
        }
        state = this.basicValidate(element, certificate);
        if (element instanceof IAttributeSupport) {
            stateAttr = new SoftReference<IVSSignature>(state);
            ((IAttributeSupport)element).setAttribute((Object)ATTR_SIGNATURESTATE, stateAttr);
        }
        return state;
    }

    protected static class CertificateSignatureValidator
    extends X509SignatureValidator<IX509Certificate> {
        protected CertificateSignatureValidator() {
        }

        @Override
        protected String getSigAlgOID(IX509Certificate element) {
            return element.getSigAlgOID();
        }

        @Override
        protected byte[] getSigAlgParams(IX509Certificate element) {
            return element.getSigAlgParams();
        }

        @Override
        protected byte[] getSignature(IX509Certificate element) {
            return element.getSignature();
        }

        @Override
        protected byte[] getTBS(IX509Certificate element) throws GeneralSecurityException {
            return element.getCertificateInfo();
        }
    }

    protected static class CRLSignatureValidator
    extends X509SignatureValidator<IX509CRL> {
        protected CRLSignatureValidator() {
        }

        @Override
        protected String getSigAlgOID(IX509CRL element) {
            return element.getSigAlgOID();
        }

        @Override
        protected byte[] getSigAlgParams(IX509CRL element) {
            return element.getSigAlgParams();
        }

        @Override
        protected byte[] getSignature(IX509CRL element) {
            return element.getSignature();
        }

        @Override
        protected byte[] getTBS(IX509CRL element) throws GeneralSecurityException {
            return element.getCertInfoList();
        }
    }

    protected static class OCSPSignatureValidator
    extends X509SignatureValidator<BasicOCSPResp> {
        protected OCSPSignatureValidator() {
        }

        @Override
        protected String getSigAlgOID(BasicOCSPResp element) {
            return element.getSignatureAlgOID().getId();
        }

        @Override
        protected byte[] getSigAlgParams(BasicOCSPResp element) throws IOException {
            ASN1Encodable parameters = element.getSignatureAlgorithmID().getParameters();
            return parameters == null ? null : parameters.toASN1Primitive().getEncoded();
        }

        @Override
        protected byte[] getSignature(BasicOCSPResp element) {
            return element.getSignature();
        }

        @Override
        protected byte[] getTBS(BasicOCSPResp element) throws GeneralSecurityException {
            return element.getTBSResponseData();
        }
    }
}

