/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.ec;

import de.intarsys.tools.crypto.CryptoTools;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;

public class EcdhTools {
    public static ECPrivateKey createPrivateKey(ECParameterSpec params, BigInteger s) throws GeneralSecurityException {
        KeyFactory g = KeyFactory.getInstance("ECDH", "BC");
        ECPrivateKeySpec keySpec = new ECPrivateKeySpec(s, params);
        ECPrivateKey key = (ECPrivateKey)g.generatePrivate(keySpec);
        return key;
    }

    public static ECPublicKey createPublicKey(ECParameterSpec params, ECPoint w) throws GeneralSecurityException {
        KeyFactory g = KeyFactory.getInstance("ECDH", "BC");
        ECPublicKeySpec keySpec = new ECPublicKeySpec(w, params);
        ECPublicKey key = (ECPublicKey)g.generatePublic(keySpec);
        return key;
    }

    public static KeyPair generateKeyPair(ECParameterSpec params) throws GeneralSecurityException {
        KeyPairGenerator g = KeyPairGenerator.getInstance("ECDH", "BC");
        g.initialize(params, CryptoTools.createSecureRandom());
        KeyPair pair = g.generateKeyPair();
        return pair;
    }
}

