/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.common;

import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.EncodingAlgorithm;
import de.intarsys.security.algorithm.common.EncryptionAlgorithm;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SignatureAlgorithm
extends Algorithm {
    private static final Map<String, SignatureAlgorithm> algorithms = new HashMap<String, SignatureAlgorithm>();
    public static final String NAME_UNKNOWN = "SignatureAlgorithm.unknown";
    public static final String NAME_UNDEFINED = "SignatureAlgorithm.undefined";
    public static final String OID_rsaEncryption = "1.2.840.113549.1.1.1";
    public static final String OID_md2WithRSAEncryption = "1.2.840.113549.1.1.2";
    public static final String OID_md4WithRSAEncryption = "1.2.840.113549.1.1.3";
    public static final String OID_md5WithRSAEncryption = "1.2.840.113549.1.1.4";
    public static final String OID_sha1WithRSAEncryption = "1.2.840.113549.1.1.5";
    public static final String OID_sha256WithRSAEncryption = "1.2.840.113549.1.1.11";
    public static final String OID_sha384WithRSAEncryption = "1.2.840.113549.1.1.12";
    public static final String OID_sha512WithRSAEncryption = "1.2.840.113549.1.1.13";
    public static final String OID_sha224WithRSAEncryption = "1.2.840.113549.1.1.14";
    public static final String OID_id_RSAES_OAEP = "1.2.840.113549.1.1.7";
    public static final String OID_RSASSA_PSS = "1.2.840.113549.1.1.10";
    public static final String OID_rsaSignatureWithripemd128 = "1.3.36.3.3.1.3";
    public static final String OID_rsaSignatureWithripemd160 = "1.3.36.3.3.1.2";
    public static final String OID_rsaSignatureWithripemd256 = "1.3.36.3.3.1.4";
    public static final String OID_ecdsaWithSHA1 = "1.2.840.10045.4.1";
    public static final String OID_ecdsaWithRecommended = "1.2.840.10045.4.2";
    public static final String OID_ecdsaWithSHA224 = "1.2.840.10045.4.3.1";
    public static final String OID_ecdsaWithSHA256 = "1.2.840.10045.4.3.2";
    public static final String OID_ecdsaWithSHA384 = "1.2.840.10045.4.3.3";
    public static final String OID_ecdsaWithSHA512 = "1.2.840.10045.4.3.4";
    public static final String OID_ecdsaWithSHA3_224 = "2.16.840.1.101.3.4.3.9";
    public static final String OID_ecdsaWithSHA3_256 = "2.16.840.1.101.3.4.3.10";
    public static final String OID_ecdsaWithSHA3_384 = "2.16.840.1.101.3.4.3.11";
    public static final String OID_ecdsaWithSHA3_512 = "2.16.840.1.101.3.4.3.12";
    public static final String OID_rsaWithSHA3_224 = "2.16.840.1.101.3.4.3.13";
    public static final String OID_rsaWithSHA3_256 = "2.16.840.1.101.3.4.3.14";
    public static final String OID_rsaWithSHA3_384 = "2.16.840.1.101.3.4.3.15";
    public static final String OID_rsaWithSHA3_512 = "2.16.840.1.101.3.4.3.16";
    public static final String OID_dhSinglePass_stdDH_sha224kdf_scheme = "1.3.132.1.11.0";
    public static final String OID_dhSinglePass_stdDH_sha256kdf_scheme = "1.3.132.1.11.1";
    public static final String OID_dhSinglePass_stdDH_sha384kdf_scheme = "1.3.132.1.11.2";
    public static final String OID_dhSinglePass_stdDH_sha512kdf_scheme = "1.3.132.1.11.3";
    public static final SignatureAlgorithm ALG_UNKNOWN = new SignatureAlgorithm("SignatureAlgorithm.unknown", "SignatureAlgorithm.unknown", EncryptionAlgorithm.ALG_UNKNOWN, DigestAlgorithm.ALG_UNKNOWN, EncodingAlgorithm.ALG_UNKNOWN, 0, null);
    public static final SignatureAlgorithm ALG_RSAEncryption = new SignatureAlgorithm("RSAEncryption", "1.2.840.113549.1.1.1", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_UNDEFINED, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_MD2WithRSAEncryption = new SignatureAlgorithm("MD2WithRSAEncryption", "1.2.840.113549.1.1.2", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_MD2, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_MD4WithRSAEncryption = new SignatureAlgorithm("MD4WithRSAEncryption", "1.2.840.113549.1.1.3", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_MD4, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_MD5WithRSAEncryption = new SignatureAlgorithm("MD5WithRSAEncryption", "1.2.840.113549.1.1.4", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_MD5, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_SHA1WithRSAEncryption = new SignatureAlgorithm("SHA1WithRSAEncryption", "1.2.840.113549.1.1.5", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_SHA1, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_RSASSA_PSS = new SignatureAlgorithm("RSASSA_PSS", "1.2.840.113549.1.1.10", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_UNDEFINED, EncodingAlgorithm.ALG_PSS, 0, null);
    public static final SignatureAlgorithm ALG_RSAES_OAEP = new SignatureAlgorithm("RSAES_OAEP", "1.2.840.113549.1.1.7", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_UNDEFINED, EncodingAlgorithm.ALG_OAEP, 0, null);
    public static final SignatureAlgorithm ALG_SHA224WithRSAEncryption = new SignatureAlgorithm("SHA224WithRSAEncryption", "1.2.840.113549.1.1.14", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_SHA224, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_SHA256WithRSAEncryption = new SignatureAlgorithm("SHA256WithRSAEncryption", "1.2.840.113549.1.1.11", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_SHA256, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_SHA384WithRSAEncryption = new SignatureAlgorithm("SHA384WithRSAEncryption", "1.2.840.113549.1.1.12", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_SHA384, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_SHA512WithRSAEncryption = new SignatureAlgorithm("SHA512WithRSAEncryption", "1.2.840.113549.1.1.13", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_SHA512, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_RSASignatureWithripemd128 = new SignatureAlgorithm("rsaSignatureWithripemd128", "1.3.36.3.3.1.3", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_RIPEMD128, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_RSASignatureWithripemd160 = new SignatureAlgorithm("rsaSignatureWithripemd160", "1.3.36.3.3.1.2", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_RIPEMD160, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_RSASignatureWithripemd256 = new SignatureAlgorithm("rsaSignatureWithripemd256", "1.3.36.3.3.1.4", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_RIPEMD256, EncodingAlgorithm.ALG_PKCS1Type1, 0, null);
    public static final SignatureAlgorithm ALG_ECDSAWithSHA1 = new SignatureAlgorithm("ECDSAWithSHA1", "1.2.840.10045.4.1", EncryptionAlgorithm.ALG_ECDSA, DigestAlgorithm.ALG_SHA1, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_ECDSAWithRecommended = new SignatureAlgorithm("ECDSAWithRecommended", "1.2.840.10045.4.2", EncryptionAlgorithm.ALG_ECDSA, DigestAlgorithm.ALG_UNDEFINED, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_ECDSAWithSHA224 = new SignatureAlgorithm("ECDSAWithSHA224", "1.2.840.10045.4.3.1", EncryptionAlgorithm.ALG_ECDSA, DigestAlgorithm.ALG_SHA224, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_ECDSAWithSHA256 = new SignatureAlgorithm("ECDSAWithSHA256", "1.2.840.10045.4.3.2", EncryptionAlgorithm.ALG_ECDSA, DigestAlgorithm.ALG_SHA256, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_ECDSAWithSHA384 = new SignatureAlgorithm("ECDSAWithSHA384", "1.2.840.10045.4.3.3", EncryptionAlgorithm.ALG_ECDSA, DigestAlgorithm.ALG_SHA384, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_ECDSAWithSHA512 = new SignatureAlgorithm("ECDSAWithSHA512", "1.2.840.10045.4.3.4", EncryptionAlgorithm.ALG_ECDSA, DigestAlgorithm.ALG_SHA512, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_ECDSAWithSHA3_224 = new SignatureAlgorithm("EDCSAWithSHA3-224", "2.16.840.1.101.3.4.3.9", EncryptionAlgorithm.ALG_ECDSA, DigestAlgorithm.ALG_SHA3_224, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_ECDSAWithSHA3_256 = new SignatureAlgorithm("ECDSAWithSHA3-256", "2.16.840.1.101.3.4.3.10", EncryptionAlgorithm.ALG_ECDSA, DigestAlgorithm.ALG_SHA3_256, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_ECDSAWithSHA3_384 = new SignatureAlgorithm("ECDSAWithSHA3-384", "2.16.840.1.101.3.4.3.11", EncryptionAlgorithm.ALG_ECDSA, DigestAlgorithm.ALG_SHA3_384, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_ECDSAWithSHA3_512 = new SignatureAlgorithm("ECDSAWithSHA3-512", "2.16.840.1.101.3.4.3.12", EncryptionAlgorithm.ALG_ECDSA, DigestAlgorithm.ALG_SHA3_512, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_RSAWithSHA3_224 = new SignatureAlgorithm("RSAWithSHA3-224", "2.16.840.1.101.3.4.3.13", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_SHA3_224, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_RSAWithSHA3_256 = new SignatureAlgorithm("RSAWithSHA3-256", "2.16.840.1.101.3.4.3.14", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_SHA3_256, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_RSAWithSHA3_384 = new SignatureAlgorithm("RSAWithSHA3-384", "2.16.840.1.101.3.4.3.15", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_SHA3_384, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_RSAWithSHA3_512 = new SignatureAlgorithm("RSAWithSHA3-512", "2.16.840.1.101.3.4.3.16", EncryptionAlgorithm.ALG_RSA, DigestAlgorithm.ALG_SHA3_512, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_DHSinglePass_stdDH_sha224kdf_scheme = new SignatureAlgorithm("dhSinglePass_stdDH_sha224kdf_scheme", "1.3.132.1.11.0", EncryptionAlgorithm.ALG_UNKNOWN, DigestAlgorithm.ALG_SHA224, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_DHSinglePass_stdDH_sha256kdf_scheme = new SignatureAlgorithm("dhSinglePass_stdDH_sha256kdf_scheme", "1.3.132.1.11.1", EncryptionAlgorithm.ALG_UNKNOWN, DigestAlgorithm.ALG_SHA256, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_DHSinglePass_stdDH_sha384kdf_scheme = new SignatureAlgorithm("dhSinglePass_stdDH_sha384kdf_scheme", "1.3.132.1.11.2", EncryptionAlgorithm.ALG_UNKNOWN, DigestAlgorithm.ALG_SHA384, EncodingAlgorithm.ALG_NONE, 0, null);
    public static final SignatureAlgorithm ALG_DHSinglePass_stdDH_sha512kdf_scheme = new SignatureAlgorithm("dhSinglePass_stdDH_sha512kdf_scheme", "1.3.132.1.11.3", EncryptionAlgorithm.ALG_UNKNOWN, DigestAlgorithm.ALG_SHA512, EncodingAlgorithm.ALG_NONE, 0, null);
    private final EncryptionAlgorithm encryptionAlgorithm;
    private final DigestAlgorithm digestAlgorithm;
    private final EncodingAlgorithm encodingAlgorithm;
    private final int keyBitSize;

    public static String createOID(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm, String detail) {
        if (EncryptionAlgorithm.ALG_RSA == encryptionAlgorithm) {
            return SignatureAlgorithm.createOIDForRSA(digestAlgorithm, detail);
        }
        if (EncryptionAlgorithm.ALG_EC == encryptionAlgorithm || EncryptionAlgorithm.ALG_ECDSA == encryptionAlgorithm) {
            return SignatureAlgorithm.createOIDForEC(digestAlgorithm, detail);
        }
        return null;
    }

    @Deprecated
    public static String createOID(String encryptionAlgorithmName, String hashAlgorithmName, String detail) {
        if ("RSA".equals(encryptionAlgorithmName)) {
            return SignatureAlgorithm.createOIDForRSA(hashAlgorithmName, detail);
        }
        if ("EC".equals(encryptionAlgorithmName) || "ECDSA".equals(encryptionAlgorithmName)) {
            return SignatureAlgorithm.createOIDForEC(hashAlgorithmName, detail);
        }
        return null;
    }

    public static String createOIDForEC(DigestAlgorithm digestAlgorithm, String detail) {
        if (DigestAlgorithm.ALG_SHA1 == digestAlgorithm) {
            return OID_ecdsaWithSHA1;
        }
        if (DigestAlgorithm.ALG_SHA224 == digestAlgorithm) {
            return OID_ecdsaWithSHA224;
        }
        if (DigestAlgorithm.ALG_SHA256 == digestAlgorithm) {
            return OID_ecdsaWithSHA256;
        }
        if (DigestAlgorithm.ALG_SHA384 == digestAlgorithm) {
            return OID_ecdsaWithSHA384;
        }
        if (DigestAlgorithm.ALG_SHA512 == digestAlgorithm) {
            return OID_ecdsaWithSHA512;
        }
        if (DigestAlgorithm.ALG_SHA3_224 == digestAlgorithm) {
            return OID_ecdsaWithSHA3_224;
        }
        if (DigestAlgorithm.ALG_SHA3_256 == digestAlgorithm) {
            return OID_ecdsaWithSHA3_256;
        }
        if (DigestAlgorithm.ALG_SHA3_384 == digestAlgorithm) {
            return OID_ecdsaWithSHA3_384;
        }
        if (DigestAlgorithm.ALG_SHA3_512 == digestAlgorithm) {
            return OID_ecdsaWithSHA3_512;
        }
        if (DigestAlgorithm.ALG_RIPEMD160 == digestAlgorithm) {
            return "1.3.36.3.3.2.2";
        }
        return null;
    }

    private static String createOIDForEC(String hashAlgorithmName, String detail) {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical(hashAlgorithmName);
        return SignatureAlgorithm.createOIDForEC(digestAlgorithm, detail);
    }

    public static String createOIDForRSA(DigestAlgorithm digestAlgorithm, String detail) {
        if ("EMSA-PSS".equals(detail)) {
            return OID_RSASSA_PSS;
        }
        if (DigestAlgorithm.ALG_MD2 == digestAlgorithm) {
            return OID_md2WithRSAEncryption;
        }
        if (DigestAlgorithm.ALG_MD4 == digestAlgorithm) {
            return OID_md4WithRSAEncryption;
        }
        if (DigestAlgorithm.ALG_MD5 == digestAlgorithm) {
            return OID_md5WithRSAEncryption;
        }
        if (DigestAlgorithm.ALG_SHA1 == digestAlgorithm) {
            return OID_sha1WithRSAEncryption;
        }
        if (DigestAlgorithm.ALG_SHA224 == digestAlgorithm) {
            return OID_sha224WithRSAEncryption;
        }
        if (DigestAlgorithm.ALG_SHA256 == digestAlgorithm) {
            return OID_sha256WithRSAEncryption;
        }
        if (DigestAlgorithm.ALG_SHA384 == digestAlgorithm) {
            return OID_sha384WithRSAEncryption;
        }
        if (DigestAlgorithm.ALG_SHA512 == digestAlgorithm) {
            return OID_sha512WithRSAEncryption;
        }
        if (DigestAlgorithm.ALG_SHA3_224 == digestAlgorithm) {
            return OID_rsaWithSHA3_224;
        }
        if (DigestAlgorithm.ALG_SHA3_256 == digestAlgorithm) {
            return OID_rsaWithSHA3_256;
        }
        if (DigestAlgorithm.ALG_SHA3_384 == digestAlgorithm) {
            return OID_rsaWithSHA3_384;
        }
        if (DigestAlgorithm.ALG_SHA3_512 == digestAlgorithm) {
            return OID_rsaWithSHA3_512;
        }
        if (DigestAlgorithm.ALG_RIPEMD128 == digestAlgorithm) {
            return OID_rsaSignatureWithripemd128;
        }
        if (DigestAlgorithm.ALG_RIPEMD160 == digestAlgorithm) {
            return OID_rsaSignatureWithripemd160;
        }
        if (DigestAlgorithm.ALG_RIPEMD256 == digestAlgorithm) {
            return OID_rsaSignatureWithripemd256;
        }
        return null;
    }

    private static String createOIDForRSA(String hashAlgorithmName, String detail) {
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical(hashAlgorithmName);
        return SignatureAlgorithm.createOIDForRSA(digestAlgorithm, detail);
    }

    public static String deriveEncryptionAlgorithmName(String signatureAlgName) {
        if (signatureAlgName == null) {
            return null;
        }
        String algo = signatureAlgName;
        int index = algo.toLowerCase().indexOf("with");
        if (index != -1) {
            algo = algo.substring(index + 4);
        }
        if ((index = algo.toLowerCase().indexOf("and")) != -1) {
            algo = algo.substring(0, index);
        }
        if (algo.toLowerCase().endsWith("encryption")) {
            index = algo.toLowerCase().indexOf("encryption");
            algo = algo.substring(0, algo.length() - 10);
        }
        return algo;
    }

    public static String deriveHashAlgorithmName(String signatureAlgName) {
        if (signatureAlgName == null) {
            return null;
        }
        String algo = signatureAlgName;
        int index = algo.toLowerCase().indexOf("with");
        if (index != -1) {
            algo = algo.substring(0, index);
        }
        return algo;
    }

    public static String getEncryptionAlgorithmName(String name) {
        if (name == null) {
            return NAME_UNKNOWN;
        }
        if (name.startsWith("1.2.840.113549.1.1")) {
            if (OID_rsaEncryption.equals(name)) {
                return "RSA";
            }
            if (OID_md2WithRSAEncryption.equals(name)) {
                return "RSA";
            }
            if (OID_md4WithRSAEncryption.equals(name)) {
                return "RSA";
            }
            if (OID_md5WithRSAEncryption.equals(name)) {
                return "RSA";
            }
            if (OID_sha1WithRSAEncryption.equals(name)) {
                return "RSA";
            }
            if (OID_sha224WithRSAEncryption.equals(name)) {
                return "RSA";
            }
            if (OID_sha256WithRSAEncryption.equals(name)) {
                return "RSA";
            }
            if (OID_sha384WithRSAEncryption.equals(name)) {
                return "RSA";
            }
            if (OID_sha512WithRSAEncryption.equals(name)) {
                return "RSA";
            }
        }
        if (name.startsWith("1.3.36.3.3.1")) {
            return "RSA";
        }
        if (name.startsWith("1.2.840.10045")) {
            if (OID_ecdsaWithSHA1.equals(name)) {
                return "ECDSA";
            }
            if ("1.2.840.10045.4.3".equals(name)) {
                return "ECDSA";
            }
            if (OID_ecdsaWithSHA224.equals(name)) {
                return "ECDSA";
            }
            if (OID_ecdsaWithSHA256.equals(name)) {
                return "ECDSA";
            }
            if (OID_ecdsaWithSHA384.equals(name)) {
                return "ECDSA";
            }
            if (OID_ecdsaWithSHA512.equals(name)) {
                return "ECDSA";
            }
        }
        return null;
    }

    public static DigestAlgorithm getHashAlgorithm(String signatureAlgorithmOid) {
        String digestAlgorithmName = SignatureAlgorithm.getHashAlgorithmName(signatureAlgorithmOid);
        return DigestAlgorithm.lookupAlgorithmCanonical(digestAlgorithmName);
    }

    public static String getHashAlgorithmName(String oid) {
        if (oid == null) {
            return null;
        }
        if ("1.2.840.113549.2.5".equals(oid)) {
            return "MD5";
        }
        if ("1.3.14.3.2.26".equals(oid)) {
            return "SHA-1";
        }
        if (oid.startsWith("1.2.840.113549.1.1")) {
            if (OID_md2WithRSAEncryption.equals(oid)) {
                return "MD2";
            }
            if (OID_md4WithRSAEncryption.equals(oid)) {
                return "MD4";
            }
            if (OID_md5WithRSAEncryption.equals(oid)) {
                return "MD5";
            }
            if (OID_sha1WithRSAEncryption.equals(oid)) {
                return "SHA-1";
            }
            if (OID_sha224WithRSAEncryption.equals(oid)) {
                return "SHA-224";
            }
            if (OID_sha256WithRSAEncryption.equals(oid)) {
                return "SHA-256";
            }
            if (OID_sha384WithRSAEncryption.equals(oid)) {
                return "SHA-384";
            }
            if (OID_sha512WithRSAEncryption.equals(oid)) {
                return "SHA-512";
            }
        }
        if (oid.startsWith("1.3.36.3")) {
            if ("1.3.36.3.2.2".equals(oid)) {
                return "RIPEMD128";
            }
            if ("1.3.36.3.2.1".equals(oid)) {
                return "RIPEMD160";
            }
            if ("1.3.36.3.2.3".equals(oid)) {
                return "RIPEMD256";
            }
            if (OID_rsaSignatureWithripemd128.equals(oid)) {
                return "RIPEMD128";
            }
            if (OID_rsaSignatureWithripemd160.equals(oid)) {
                return "RIPEMD160";
            }
            if (OID_rsaSignatureWithripemd256.equals(oid)) {
                return "RIPEMD256";
            }
        }
        if (oid.startsWith("2.16.840.1.101.3.4")) {
            if ("2.16.840.1.101.3.4.2.4".equals(oid)) {
                return "SHA-224";
            }
            if ("2.16.840.1.101.3.4.2.1".equals(oid)) {
                return "SHA-256";
            }
            if ("2.16.840.1.101.3.4.2.2".equals(oid)) {
                return "SHA-384";
            }
            if ("2.16.840.1.101.3.4.2.3".equals(oid)) {
                return "SHA-512";
            }
        }
        if (oid.startsWith("1.3.132.1")) {
            if (OID_dhSinglePass_stdDH_sha224kdf_scheme.equals(oid)) {
                return "SHA-224";
            }
            if (OID_dhSinglePass_stdDH_sha256kdf_scheme.equals(oid)) {
                return "SHA-256";
            }
            if (OID_dhSinglePass_stdDH_sha384kdf_scheme.equals(oid)) {
                return "SHA-384";
            }
            if (OID_dhSinglePass_stdDH_sha512kdf_scheme.equals(oid)) {
                return "SHA-512";
            }
        }
        if (oid.startsWith("1.2.840.10045")) {
            if (OID_ecdsaWithSHA1.equals(oid)) {
                return "SHA-1";
            }
            if (OID_ecdsaWithSHA224.equals(oid)) {
                return "SHA-224";
            }
            if (OID_ecdsaWithSHA256.equals(oid)) {
                return "SHA-256";
            }
            if (OID_ecdsaWithSHA384.equals(oid)) {
                return "SHA-384";
            }
            if (OID_ecdsaWithSHA512.equals(oid)) {
                return "SHA-512";
            }
        }
        return null;
    }

    public static SignatureAlgorithm lookupAlgorithm(String name) {
        return algorithms.get(name);
    }

    public static SignatureAlgorithm lookupAlgorithmCanonical(String name) {
        SignatureAlgorithm result = algorithms.get(name);
        return result == null ? null : result.getCanonical();
    }

    public SignatureAlgorithm(String name, DigestAlgorithm digestAlgorithm, SignatureAlgorithm template) {
        this(name, null, template.getEncryptionAlgorithm(), digestAlgorithm, template.getEncodingAlgorithm(), template.getKeyBitSize(), null);
    }

    public SignatureAlgorithm(String name, SignatureAlgorithm aliased) {
        this(name, aliased.getOid(), aliased.getEncryptionAlgorithm(), aliased.getDigestAlgorithm(), aliased.getEncodingAlgorithm(), aliased.getKeyBitSize(), aliased);
    }

    public SignatureAlgorithm(String name, String oid, EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm, EncodingAlgorithm encodingAlgorithm, int keyBitSize, SignatureAlgorithm canonical) {
        super(name, oid, canonical);
        this.encryptionAlgorithm = Objects.requireNonNull(encryptionAlgorithm, "encryptionAlgorithm must not be null");
        this.digestAlgorithm = Objects.requireNonNull(digestAlgorithm, "digestAlgorithm must not be null");
        this.encodingAlgorithm = Objects.requireNonNull(encodingAlgorithm, "encodingAlgorithm must not be null");
        this.keyBitSize = keyBitSize;
        algorithms.put(name, this);
        algorithms.putIfAbsent(oid, this);
    }

    @Override
    public SignatureAlgorithm getCanonical() {
        return (SignatureAlgorithm)super.getCanonical();
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public EncodingAlgorithm getEncodingAlgorithm() {
        return this.encodingAlgorithm;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public int getKeyBitSize() {
        return this.keyBitSize;
    }

    static {
        new SignatureAlgorithm("RSASSA-PSS", ALG_RSASSA_PSS);
        new SignatureAlgorithm("RSAES-OAEP", ALG_RSAES_OAEP);
    }
}

