/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.locator;

import de.intarsys.tools.content.ICharsetSupport;
import de.intarsys.tools.content.IMimeTypeSupport;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.http.common.HttpConstants;
import de.intarsys.tools.http.common.HttpTools;
import de.intarsys.tools.locator.AbstractLocator;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.FileItem;

public class FileItemLocator
extends AbstractLocator
implements IMimeTypeSupport,
ICharsetSupport {
    private final FileItem item;
    private final String name;
    private ILocator delegate;
    private final String contentType;
    private final String charset;

    public static FileItemLocator create(FileItem item) {
        return new FileItemLocator(item);
    }

    public FileItemLocator(FileItem item) {
        this.item = item;
        this.name = StringTools.isEmpty((String)item.getName()) ? item.getFieldName() : FileTools.trimPath((String)FileTools.getFileName((String)item.getName()));
        this.charset = HttpTools.getHeaderElementParam(item.getContentType(), "charset", HttpConstants.CHARSET_DEFAULT);
        this.contentType = HttpTools.getHeaderElementName(item.getContentType(), "text/plain");
    }

    protected ILocator createDelegate() {
        if (this.item instanceof DiskFileItem && !((DiskFileItem)this.item).isInMemory()) {
            return new FileLocator(((DiskFileItem)this.item).getPath().toFile());
        }
        try {
            return new ByteArrayLocator(this.item.get(), this.getName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void delete() throws IOException {
        this.item.delete();
    }

    public boolean exists() {
        return true;
    }

    public String getCharset() {
        return this.charset;
    }

    public ILocator getChild(String name) {
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }

    protected synchronized ILocator getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.createDelegate();
        }
        return this.delegate;
    }

    public InputStream getInputStream() throws IOException {
        return this.getDelegate().getInputStream();
    }

    public long getLength() throws IOException {
        return this.getDelegate().getLength();
    }

    public String getName() {
        return FileTools.getFileName((String)this.name);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getDelegate().getOutputStream();
    }

    public ILocator getParent() {
        return null;
    }

    public String getPath() {
        return this.name;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        return this.getDelegate().getRandomAccess();
    }

    public Reader getReader() throws IOException {
        return this.getDelegate().getReader(this.getCharset());
    }

    public Reader getReader(String encoding) throws IOException {
        return this.getDelegate().getReader(encoding);
    }

    public Writer getWriter() throws IOException {
        return this.getDelegate().getWriter(this.getCharset());
    }

    public Writer getWriter(String encoding) throws IOException {
        return this.getDelegate().getWriter(encoding);
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return new ILocator[0];
    }

    public void rename(String newName) throws IOException {
        this.getDelegate().rename(newName);
    }

    public void setReadOnly() {
    }

    public void synch() {
    }

    public URI toURI() {
        return this.getDelegate().toURI();
    }
}

