/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.common.signature;

import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.device.timestamp.device.TimestampTools;
import de.intarsys.security.method.common.signature.SignatureOptions;
import de.intarsys.security.signature.RevocationInfoDepth;
import de.intarsys.security.signature.RevocationInfoType;
import de.intarsys.security.signature.ValidationDataOptions;
import de.intarsys.security.signature.etsi.api.ConformanceLevel;
import de.intarsys.security.signature.etsi.service.SignatureCreationService;
import de.intarsys.security.signature.policy.ICommitmentTypeIndication;
import de.intarsys.security.signature.policy.IPolicyReference;
import de.intarsys.security.signature.policy.PolicyTools;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Collections;
import java.util.List;

public class AdESSignerTools {
    protected static final String ARG_INCLUDEOCSP = "includeOcsp";
    public static final String ARG_INCLUDEREVOCATIONINFO = "includeRevocationInfo";
    public static final String ARG_REVOCATION_INFO_DEPTH = "revocationInfoDepth";
    public static final String ARG_REVOCATION_INFO_TYPE = "revocationInfoType";

    public static ITimestampCreator createTimestampCreator(IArgs args) {
        Object value = args.get("timestampDevice");
        if (value == null) {
            value = ArgTools.getString((IArgs)args, (String)"timestampServiceName", null);
        }
        try {
            return TimestampTools.createTimestampCreator(value);
        }
        catch (ObjectCreationException e) {
            throw new IllegalArgumentException("'timestampDevice' invalid", ExceptionTools.unwrap((Throwable)e));
        }
    }

    public static List<IX509AttributeCertificate> getAttributeCertificates(IArgs args) {
        return ArgTools.getList((IArgs)args, (String)"attributeCertificates", Collections.emptyList());
    }

    public static ICommitmentTypeIndication getCommitmentTypeIndication(IArgs args) throws ObjectCreationException {
        Object value = args.get("commitmentType");
        if (value == null) {
            return null;
        }
        return PolicyTools.createCommitmentTypeIndication((Object)value);
    }

    public static RevocationInfoDepth getRevocationInfoDepth(IArgs args) {
        ConformanceLevel level;
        RevocationInfoDepth depth = (RevocationInfoDepth)ArgTools.getEnumItem((IArgs)args, (EnumMeta)RevocationInfoDepth.META, (String)ARG_REVOCATION_INFO_DEPTH, (EnumItem)((RevocationInfoDepth)null));
        if (depth == null && (level = SignatureCreationService.getConformanceLevel((IArgs)args, (ConformanceLevel)ConformanceLevel.B)).isValidationDataRequired()) {
            depth = RevocationInfoDepth.ALL;
        }
        if (depth == null) {
            depth = (RevocationInfoDepth)ArgTools.getEnumItem((IArgs)args, (EnumMeta)RevocationInfoDepth.META, (String)ARG_INCLUDEREVOCATIONINFO, (EnumItem)((RevocationInfoDepth)null));
        }
        if (depth == null && ArgTools.getBoolStrict((IArgs)args, (String)ARG_INCLUDEOCSP, (boolean)false)) {
            depth = RevocationInfoDepth.SIGNER;
        }
        if (depth == null) {
            depth = (RevocationInfoDepth)RevocationInfoDepth.META.getDefault();
        }
        return depth;
    }

    public static RevocationInfoType getRevocationInfoType(IArgs args) {
        return (RevocationInfoType)ArgTools.getEnumItem((IArgs)args, (EnumMeta)RevocationInfoType.META, (String)ARG_REVOCATION_INFO_TYPE);
    }

    public static SignatureOptions getSignatureOptions(IArgs args) {
        ValidationDataOptions validationDataOptions = AdESSignerTools.getValidationDataOptions(args);
        ConformanceLevel level = SignatureCreationService.getConformanceLevel((IArgs)args, (ConformanceLevel)ConformanceLevel.B);
        boolean addTimestamp = ArgTools.getBoolStrict((IArgs)args, (String)"digestSigner.args.addTimestamp", (boolean)false);
        boolean hasTimestampCreator = AdESSignerTools.hasTimestampCreator(args);
        return new SignatureOptions(addTimestamp || hasTimestampCreator || level.isTimestampRequired(), hasTimestampCreator, validationDataOptions);
    }

    public static IPolicyReference getSignaturePolicy(IArgs args) throws ObjectCreationException {
        Object value = args.get("signaturePolicy");
        if (value == null) {
            return null;
        }
        return PolicyTools.createPolicyReference((Object)value);
    }

    public static ISigner getSigner(IArgs args) {
        ISigner result = (ISigner)args.get("signer");
        return result;
    }

    public static ValidationDataOptions getValidationDataOptions(IArgs args) {
        RevocationInfoDepth depth = AdESSignerTools.getRevocationInfoDepth(args);
        RevocationInfoType type = AdESSignerTools.getRevocationInfoType(args);
        return new ValidationDataOptions(depth, type);
    }

    public static boolean hasTimestampCreator(IArgs args) {
        Object value = args.get("timestampDevice");
        if (value == null) {
            value = ArgTools.getString((IArgs)args, (String)"timestampServiceName", null);
        }
        try {
            return TimestampTools.createTimestampDevice(value) != null;
        }
        catch (ObjectCreationException e) {
            throw new IllegalArgumentException("'timestampDevice' invalid", ExceptionTools.unwrap((Throwable)e));
        }
    }

    public static boolean isIncludeCertificates(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"includeCertificates", (boolean)true);
    }

    private AdESSignerTools() {
    }
}

