/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.jca.device;

import de.intarsys.security.device.IDevice;
import de.intarsys.security.jca.device.DeviceKeyStoreSpi;
import de.intarsys.security.jca.device.DeviceSignerSignatureSpi;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Optional;

public class DeviceJCAProvider
extends Provider {
    private static final String SIGNATURE = "Signature";
    private static final String KEYSTORE = "KeyStore";
    private IDevice device;

    public static void ensureRegistered() {
        Optional<Provider> registered = Arrays.stream(Security.getProviders()).filter(DeviceJCAProvider.class::isInstance).findAny();
        if (!registered.isPresent()) {
            Security.addProvider(new DeviceJCAProvider());
        }
    }

    public DeviceJCAProvider() {
        this(null, "device");
    }

    public DeviceJCAProvider(IDevice device) {
        this(device, "device");
    }

    public DeviceJCAProvider(IDevice device, String name) {
        super(name, 1.0, "");
        this.device = device;
    }

    @Override
    public synchronized Provider.Service getService(String type, final String algorithm) {
        if (this.device != null && KEYSTORE.equals(type)) {
            return new Provider.Service(this, KEYSTORE, algorithm, "", null, null){

                @Override
                public Object newInstance(Object constructorParameter) {
                    return new DeviceKeyStoreSpi(DeviceJCAProvider.this.device);
                }
            };
        }
        if (SIGNATURE.equals(type)) {
            return new Provider.Service(this, SIGNATURE, algorithm, "", null, null){

                @Override
                public Object newInstance(Object constructorParameter) {
                    return DeviceSignerSignatureSpi.create(algorithm);
                }
            };
        }
        return super.getService(type, algorithm);
    }
}

