/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.key;

import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.creation.CertificateSignerException;
import de.intarsys.security.certificate.creation.ICertificateSigner;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.ToBeSignedData;
import de.intarsys.tools.exception.ExceptionTools;

public class CertificateSigner
implements ICertificateSigner {
    private ISigner signer;

    public CertificateSigner(ISigner signer) {
        this.signer = signer;
    }

    public IX509PublicKeyCertificate[] getCertificatePath() {
        return this.getSigner().getCertificatePath();
    }

    public String getEncryptionAlgorithmName() {
        return this.getSigner().getEncryptionAlgorithmName();
    }

    public ISigner getSigner() {
        return this.signer;
    }

    public byte[] sign(byte[] data) throws CertificateSignerException {
        try {
            return ((ISignatureData)this.getSigner().sign((IToBeSignedData)ToBeSignedData.create((byte[])data)).get()).getEncodedSignature();
        }
        catch (Exception e) {
            throw new CertificateSignerException(ExceptionTools.unwrap((Throwable)e));
        }
    }
}

